/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class GiftCardActivityTransferBalanceTo {
    private final String transferFromGiftCardId;
    private final Money amountMoney;

    @JsonCreator
    public GiftCardActivityTransferBalanceTo(@JsonProperty(value="transfer_from_gift_card_id") String transferFromGiftCardId, @JsonProperty(value="amount_money") Money amountMoney) {
        this.transferFromGiftCardId = transferFromGiftCardId;
        this.amountMoney = amountMoney;
    }

    @JsonGetter(value="transfer_from_gift_card_id")
    public String getTransferFromGiftCardId() {
        return this.transferFromGiftCardId;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    public int hashCode() {
        return Objects.hash(this.transferFromGiftCardId, this.amountMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GiftCardActivityTransferBalanceTo)) {
            return false;
        }
        GiftCardActivityTransferBalanceTo other = (GiftCardActivityTransferBalanceTo)obj;
        return Objects.equals(this.transferFromGiftCardId, other.transferFromGiftCardId) && Objects.equals(this.amountMoney, other.amountMoney);
    }

    public String toString() {
        return "GiftCardActivityTransferBalanceTo [transferFromGiftCardId=" + this.transferFromGiftCardId + ", amountMoney=" + this.amountMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.transferFromGiftCardId, this.amountMoney);
        return builder;
    }

    public static class Builder {
        private String transferFromGiftCardId;
        private Money amountMoney;

        public Builder(String transferFromGiftCardId, Money amountMoney) {
            this.transferFromGiftCardId = transferFromGiftCardId;
            this.amountMoney = amountMoney;
        }

        public Builder transferFromGiftCardId(String transferFromGiftCardId) {
            this.transferFromGiftCardId = transferFromGiftCardId;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public GiftCardActivityTransferBalanceTo build() {
            return new GiftCardActivityTransferBalanceTo(this.transferFromGiftCardId, this.amountMoney);
        }
    }
}

