/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class InventoryCount {
    private final OptionalNullable<String> catalogObjectId;
    private final OptionalNullable<String> catalogObjectType;
    private final String state;
    private final OptionalNullable<String> locationId;
    private final OptionalNullable<String> quantity;
    private final String calculatedAt;
    private final Boolean isEstimated;

    @JsonCreator
    public InventoryCount(@JsonProperty(value="catalog_object_id") String catalogObjectId, @JsonProperty(value="catalog_object_type") String catalogObjectType, @JsonProperty(value="state") String state, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="quantity") String quantity, @JsonProperty(value="calculated_at") String calculatedAt, @JsonProperty(value="is_estimated") Boolean isEstimated) {
        this.catalogObjectId = OptionalNullable.of((Object)catalogObjectId);
        this.catalogObjectType = OptionalNullable.of((Object)catalogObjectType);
        this.state = state;
        this.locationId = OptionalNullable.of((Object)locationId);
        this.quantity = OptionalNullable.of((Object)quantity);
        this.calculatedAt = calculatedAt;
        this.isEstimated = isEstimated;
    }

    protected InventoryCount(OptionalNullable<String> catalogObjectId, OptionalNullable<String> catalogObjectType, String state, OptionalNullable<String> locationId, OptionalNullable<String> quantity, String calculatedAt, Boolean isEstimated) {
        this.catalogObjectId = catalogObjectId;
        this.catalogObjectType = catalogObjectType;
        this.state = state;
        this.locationId = locationId;
        this.quantity = quantity;
        this.calculatedAt = calculatedAt;
        this.isEstimated = isEstimated;
    }

    @JsonGetter(value="catalog_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonIgnore
    public String getCatalogObjectId() {
        return (String)OptionalNullable.getFrom(this.catalogObjectId);
    }

    @JsonGetter(value="catalog_object_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCatalogObjectType() {
        return this.catalogObjectType;
    }

    @JsonIgnore
    public String getCatalogObjectType() {
        return (String)OptionalNullable.getFrom(this.catalogObjectType);
    }

    @JsonGetter(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    @JsonGetter(value="quantity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetQuantity() {
        return this.quantity;
    }

    @JsonIgnore
    public String getQuantity() {
        return (String)OptionalNullable.getFrom(this.quantity);
    }

    @JsonGetter(value="calculated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCalculatedAt() {
        return this.calculatedAt;
    }

    @JsonGetter(value="is_estimated")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIsEstimated() {
        return this.isEstimated;
    }

    public int hashCode() {
        return Objects.hash(this.catalogObjectId, this.catalogObjectType, this.state, this.locationId, this.quantity, this.calculatedAt, this.isEstimated);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InventoryCount)) {
            return false;
        }
        InventoryCount other = (InventoryCount)obj;
        return Objects.equals(this.catalogObjectId, other.catalogObjectId) && Objects.equals(this.catalogObjectType, other.catalogObjectType) && Objects.equals(this.state, other.state) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.calculatedAt, other.calculatedAt) && Objects.equals(this.isEstimated, other.isEstimated);
    }

    public String toString() {
        return "InventoryCount [catalogObjectId=" + this.catalogObjectId + ", catalogObjectType=" + this.catalogObjectType + ", state=" + this.state + ", locationId=" + this.locationId + ", quantity=" + this.quantity + ", calculatedAt=" + this.calculatedAt + ", isEstimated=" + this.isEstimated + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().state(this.getState()).calculatedAt(this.getCalculatedAt()).isEstimated(this.getIsEstimated());
        builder.catalogObjectId = this.internalGetCatalogObjectId();
        builder.catalogObjectType = this.internalGetCatalogObjectType();
        builder.locationId = this.internalGetLocationId();
        builder.quantity = this.internalGetQuantity();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> catalogObjectId;
        private OptionalNullable<String> catalogObjectType;
        private String state;
        private OptionalNullable<String> locationId;
        private OptionalNullable<String> quantity;
        private String calculatedAt;
        private Boolean isEstimated;

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = OptionalNullable.of((Object)catalogObjectId);
            return this;
        }

        public Builder unsetCatalogObjectId() {
            this.catalogObjectId = null;
            return this;
        }

        public Builder catalogObjectType(String catalogObjectType) {
            this.catalogObjectType = OptionalNullable.of((Object)catalogObjectType);
            return this;
        }

        public Builder unsetCatalogObjectType() {
            this.catalogObjectType = null;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Builder quantity(String quantity) {
            this.quantity = OptionalNullable.of((Object)quantity);
            return this;
        }

        public Builder unsetQuantity() {
            this.quantity = null;
            return this;
        }

        public Builder calculatedAt(String calculatedAt) {
            this.calculatedAt = calculatedAt;
            return this;
        }

        public Builder isEstimated(Boolean isEstimated) {
            this.isEstimated = isEstimated;
            return this;
        }

        public InventoryCount build() {
            return new InventoryCount(this.catalogObjectId, this.catalogObjectType, this.state, this.locationId, this.quantity, this.calculatedAt, this.isEstimated);
        }
    }
}

