/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.InvoiceAcceptedPaymentMethods;
import com.squareup.square.models.InvoiceAttachment;
import com.squareup.square.models.InvoiceCustomField;
import com.squareup.square.models.InvoicePaymentRequest;
import com.squareup.square.models.InvoiceRecipient;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class Invoice {
    private final String id;
    private final Integer version;
    private final OptionalNullable<String> locationId;
    private final OptionalNullable<String> orderId;
    private final InvoiceRecipient primaryRecipient;
    private final OptionalNullable<List<InvoicePaymentRequest>> paymentRequests;
    private final String deliveryMethod;
    private final OptionalNullable<String> invoiceNumber;
    private final OptionalNullable<String> title;
    private final OptionalNullable<String> description;
    private final OptionalNullable<String> scheduledAt;
    private final String publicUrl;
    private final Money nextPaymentAmountMoney;
    private final String status;
    private final String timezone;
    private final String createdAt;
    private final String updatedAt;
    private final InvoiceAcceptedPaymentMethods acceptedPaymentMethods;
    private final OptionalNullable<List<InvoiceCustomField>> customFields;
    private final String subscriptionId;
    private final OptionalNullable<String> saleOrServiceDate;
    private final OptionalNullable<String> paymentConditions;
    private final OptionalNullable<Boolean> storePaymentMethodEnabled;
    private final List<InvoiceAttachment> attachments;

    @JsonCreator
    public Invoice(@JsonProperty(value="id") String id, @JsonProperty(value="version") Integer version, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="primary_recipient") InvoiceRecipient primaryRecipient, @JsonProperty(value="payment_requests") List<InvoicePaymentRequest> paymentRequests, @JsonProperty(value="delivery_method") String deliveryMethod, @JsonProperty(value="invoice_number") String invoiceNumber, @JsonProperty(value="title") String title, @JsonProperty(value="description") String description, @JsonProperty(value="scheduled_at") String scheduledAt, @JsonProperty(value="public_url") String publicUrl, @JsonProperty(value="next_payment_amount_money") Money nextPaymentAmountMoney, @JsonProperty(value="status") String status, @JsonProperty(value="timezone") String timezone, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="accepted_payment_methods") InvoiceAcceptedPaymentMethods acceptedPaymentMethods, @JsonProperty(value="custom_fields") List<InvoiceCustomField> customFields, @JsonProperty(value="subscription_id") String subscriptionId, @JsonProperty(value="sale_or_service_date") String saleOrServiceDate, @JsonProperty(value="payment_conditions") String paymentConditions, @JsonProperty(value="store_payment_method_enabled") Boolean storePaymentMethodEnabled, @JsonProperty(value="attachments") List<InvoiceAttachment> attachments) {
        this.id = id;
        this.version = version;
        this.locationId = OptionalNullable.of((Object)locationId);
        this.orderId = OptionalNullable.of((Object)orderId);
        this.primaryRecipient = primaryRecipient;
        this.paymentRequests = OptionalNullable.of(paymentRequests);
        this.deliveryMethod = deliveryMethod;
        this.invoiceNumber = OptionalNullable.of((Object)invoiceNumber);
        this.title = OptionalNullable.of((Object)title);
        this.description = OptionalNullable.of((Object)description);
        this.scheduledAt = OptionalNullable.of((Object)scheduledAt);
        this.publicUrl = publicUrl;
        this.nextPaymentAmountMoney = nextPaymentAmountMoney;
        this.status = status;
        this.timezone = timezone;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.acceptedPaymentMethods = acceptedPaymentMethods;
        this.customFields = OptionalNullable.of(customFields);
        this.subscriptionId = subscriptionId;
        this.saleOrServiceDate = OptionalNullable.of((Object)saleOrServiceDate);
        this.paymentConditions = OptionalNullable.of((Object)paymentConditions);
        this.storePaymentMethodEnabled = OptionalNullable.of((Object)storePaymentMethodEnabled);
        this.attachments = attachments;
    }

    protected Invoice(String id, Integer version, OptionalNullable<String> locationId, OptionalNullable<String> orderId, InvoiceRecipient primaryRecipient, OptionalNullable<List<InvoicePaymentRequest>> paymentRequests, String deliveryMethod, OptionalNullable<String> invoiceNumber, OptionalNullable<String> title, OptionalNullable<String> description, OptionalNullable<String> scheduledAt, String publicUrl, Money nextPaymentAmountMoney, String status, String timezone, String createdAt, String updatedAt, InvoiceAcceptedPaymentMethods acceptedPaymentMethods, OptionalNullable<List<InvoiceCustomField>> customFields, String subscriptionId, OptionalNullable<String> saleOrServiceDate, OptionalNullable<String> paymentConditions, OptionalNullable<Boolean> storePaymentMethodEnabled, List<InvoiceAttachment> attachments) {
        this.id = id;
        this.version = version;
        this.locationId = locationId;
        this.orderId = orderId;
        this.primaryRecipient = primaryRecipient;
        this.paymentRequests = paymentRequests;
        this.deliveryMethod = deliveryMethod;
        this.invoiceNumber = invoiceNumber;
        this.title = title;
        this.description = description;
        this.scheduledAt = scheduledAt;
        this.publicUrl = publicUrl;
        this.nextPaymentAmountMoney = nextPaymentAmountMoney;
        this.status = status;
        this.timezone = timezone;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.acceptedPaymentMethods = acceptedPaymentMethods;
        this.customFields = customFields;
        this.subscriptionId = subscriptionId;
        this.saleOrServiceDate = saleOrServiceDate;
        this.paymentConditions = paymentConditions;
        this.storePaymentMethodEnabled = storePaymentMethodEnabled;
        this.attachments = attachments;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetOrderId() {
        return this.orderId;
    }

    @JsonIgnore
    public String getOrderId() {
        return (String)OptionalNullable.getFrom(this.orderId);
    }

    @JsonGetter(value="primary_recipient")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public InvoiceRecipient getPrimaryRecipient() {
        return this.primaryRecipient;
    }

    @JsonGetter(value="payment_requests")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<InvoicePaymentRequest>> internalGetPaymentRequests() {
        return this.paymentRequests;
    }

    @JsonIgnore
    public List<InvoicePaymentRequest> getPaymentRequests() {
        return (List)OptionalNullable.getFrom(this.paymentRequests);
    }

    @JsonGetter(value="delivery_method")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDeliveryMethod() {
        return this.deliveryMethod;
    }

    @JsonGetter(value="invoice_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetInvoiceNumber() {
        return this.invoiceNumber;
    }

    @JsonIgnore
    public String getInvoiceNumber() {
        return (String)OptionalNullable.getFrom(this.invoiceNumber);
    }

    @JsonGetter(value="title")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTitle() {
        return this.title;
    }

    @JsonIgnore
    public String getTitle() {
        return (String)OptionalNullable.getFrom(this.title);
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDescription() {
        return this.description;
    }

    @JsonIgnore
    public String getDescription() {
        return (String)OptionalNullable.getFrom(this.description);
    }

    @JsonGetter(value="scheduled_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetScheduledAt() {
        return this.scheduledAt;
    }

    @JsonIgnore
    public String getScheduledAt() {
        return (String)OptionalNullable.getFrom(this.scheduledAt);
    }

    @JsonGetter(value="public_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPublicUrl() {
        return this.publicUrl;
    }

    @JsonGetter(value="next_payment_amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getNextPaymentAmountMoney() {
        return this.nextPaymentAmountMoney;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="timezone")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTimezone() {
        return this.timezone;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="accepted_payment_methods")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public InvoiceAcceptedPaymentMethods getAcceptedPaymentMethods() {
        return this.acceptedPaymentMethods;
    }

    @JsonGetter(value="custom_fields")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<InvoiceCustomField>> internalGetCustomFields() {
        return this.customFields;
    }

    @JsonIgnore
    public List<InvoiceCustomField> getCustomFields() {
        return (List)OptionalNullable.getFrom(this.customFields);
    }

    @JsonGetter(value="subscription_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @JsonGetter(value="sale_or_service_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetSaleOrServiceDate() {
        return this.saleOrServiceDate;
    }

    @JsonIgnore
    public String getSaleOrServiceDate() {
        return (String)OptionalNullable.getFrom(this.saleOrServiceDate);
    }

    @JsonGetter(value="payment_conditions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPaymentConditions() {
        return this.paymentConditions;
    }

    @JsonIgnore
    public String getPaymentConditions() {
        return (String)OptionalNullable.getFrom(this.paymentConditions);
    }

    @JsonGetter(value="store_payment_method_enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetStorePaymentMethodEnabled() {
        return this.storePaymentMethodEnabled;
    }

    @JsonIgnore
    public Boolean getStorePaymentMethodEnabled() {
        return (Boolean)OptionalNullable.getFrom(this.storePaymentMethodEnabled);
    }

    @JsonGetter(value="attachments")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<InvoiceAttachment> getAttachments() {
        return this.attachments;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.locationId, this.orderId, this.primaryRecipient, this.paymentRequests, this.deliveryMethod, this.invoiceNumber, this.title, this.description, this.scheduledAt, this.publicUrl, this.nextPaymentAmountMoney, this.status, this.timezone, this.createdAt, this.updatedAt, this.acceptedPaymentMethods, this.customFields, this.subscriptionId, this.saleOrServiceDate, this.paymentConditions, this.storePaymentMethodEnabled, this.attachments);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Invoice)) {
            return false;
        }
        Invoice other = (Invoice)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.version, other.version) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.orderId, other.orderId) && Objects.equals(this.primaryRecipient, other.primaryRecipient) && Objects.equals(this.paymentRequests, other.paymentRequests) && Objects.equals(this.deliveryMethod, other.deliveryMethod) && Objects.equals(this.invoiceNumber, other.invoiceNumber) && Objects.equals(this.title, other.title) && Objects.equals(this.description, other.description) && Objects.equals(this.scheduledAt, other.scheduledAt) && Objects.equals(this.publicUrl, other.publicUrl) && Objects.equals(this.nextPaymentAmountMoney, other.nextPaymentAmountMoney) && Objects.equals(this.status, other.status) && Objects.equals(this.timezone, other.timezone) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.acceptedPaymentMethods, other.acceptedPaymentMethods) && Objects.equals(this.customFields, other.customFields) && Objects.equals(this.subscriptionId, other.subscriptionId) && Objects.equals(this.saleOrServiceDate, other.saleOrServiceDate) && Objects.equals(this.paymentConditions, other.paymentConditions) && Objects.equals(this.storePaymentMethodEnabled, other.storePaymentMethodEnabled) && Objects.equals(this.attachments, other.attachments);
    }

    public String toString() {
        return "Invoice [id=" + this.id + ", version=" + this.version + ", locationId=" + this.locationId + ", orderId=" + this.orderId + ", primaryRecipient=" + this.primaryRecipient + ", paymentRequests=" + this.paymentRequests + ", deliveryMethod=" + this.deliveryMethod + ", invoiceNumber=" + this.invoiceNumber + ", title=" + this.title + ", description=" + this.description + ", scheduledAt=" + this.scheduledAt + ", publicUrl=" + this.publicUrl + ", nextPaymentAmountMoney=" + this.nextPaymentAmountMoney + ", status=" + this.status + ", timezone=" + this.timezone + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", acceptedPaymentMethods=" + this.acceptedPaymentMethods + ", customFields=" + this.customFields + ", subscriptionId=" + this.subscriptionId + ", saleOrServiceDate=" + this.saleOrServiceDate + ", paymentConditions=" + this.paymentConditions + ", storePaymentMethodEnabled=" + this.storePaymentMethodEnabled + ", attachments=" + this.attachments + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).version(this.getVersion()).primaryRecipient(this.getPrimaryRecipient()).deliveryMethod(this.getDeliveryMethod()).publicUrl(this.getPublicUrl()).nextPaymentAmountMoney(this.getNextPaymentAmountMoney()).status(this.getStatus()).timezone(this.getTimezone()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).acceptedPaymentMethods(this.getAcceptedPaymentMethods()).subscriptionId(this.getSubscriptionId()).attachments(this.getAttachments());
        builder.locationId = this.internalGetLocationId();
        builder.orderId = this.internalGetOrderId();
        builder.paymentRequests = this.internalGetPaymentRequests();
        builder.invoiceNumber = this.internalGetInvoiceNumber();
        builder.title = this.internalGetTitle();
        builder.description = this.internalGetDescription();
        builder.scheduledAt = this.internalGetScheduledAt();
        builder.customFields = this.internalGetCustomFields();
        builder.saleOrServiceDate = this.internalGetSaleOrServiceDate();
        builder.paymentConditions = this.internalGetPaymentConditions();
        builder.storePaymentMethodEnabled = this.internalGetStorePaymentMethodEnabled();
        return builder;
    }

    public static class Builder {
        private String id;
        private Integer version;
        private OptionalNullable<String> locationId;
        private OptionalNullable<String> orderId;
        private InvoiceRecipient primaryRecipient;
        private OptionalNullable<List<InvoicePaymentRequest>> paymentRequests;
        private String deliveryMethod;
        private OptionalNullable<String> invoiceNumber;
        private OptionalNullable<String> title;
        private OptionalNullable<String> description;
        private OptionalNullable<String> scheduledAt;
        private String publicUrl;
        private Money nextPaymentAmountMoney;
        private String status;
        private String timezone;
        private String createdAt;
        private String updatedAt;
        private InvoiceAcceptedPaymentMethods acceptedPaymentMethods;
        private OptionalNullable<List<InvoiceCustomField>> customFields;
        private String subscriptionId;
        private OptionalNullable<String> saleOrServiceDate;
        private OptionalNullable<String> paymentConditions;
        private OptionalNullable<Boolean> storePaymentMethodEnabled;
        private List<InvoiceAttachment> attachments;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = OptionalNullable.of((Object)orderId);
            return this;
        }

        public Builder unsetOrderId() {
            this.orderId = null;
            return this;
        }

        public Builder primaryRecipient(InvoiceRecipient primaryRecipient) {
            this.primaryRecipient = primaryRecipient;
            return this;
        }

        public Builder paymentRequests(List<InvoicePaymentRequest> paymentRequests) {
            this.paymentRequests = OptionalNullable.of(paymentRequests);
            return this;
        }

        public Builder unsetPaymentRequests() {
            this.paymentRequests = null;
            return this;
        }

        public Builder deliveryMethod(String deliveryMethod) {
            this.deliveryMethod = deliveryMethod;
            return this;
        }

        public Builder invoiceNumber(String invoiceNumber) {
            this.invoiceNumber = OptionalNullable.of((Object)invoiceNumber);
            return this;
        }

        public Builder unsetInvoiceNumber() {
            this.invoiceNumber = null;
            return this;
        }

        public Builder title(String title) {
            this.title = OptionalNullable.of((Object)title);
            return this;
        }

        public Builder unsetTitle() {
            this.title = null;
            return this;
        }

        public Builder description(String description) {
            this.description = OptionalNullable.of((Object)description);
            return this;
        }

        public Builder unsetDescription() {
            this.description = null;
            return this;
        }

        public Builder scheduledAt(String scheduledAt) {
            this.scheduledAt = OptionalNullable.of((Object)scheduledAt);
            return this;
        }

        public Builder unsetScheduledAt() {
            this.scheduledAt = null;
            return this;
        }

        public Builder publicUrl(String publicUrl) {
            this.publicUrl = publicUrl;
            return this;
        }

        public Builder nextPaymentAmountMoney(Money nextPaymentAmountMoney) {
            this.nextPaymentAmountMoney = nextPaymentAmountMoney;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder acceptedPaymentMethods(InvoiceAcceptedPaymentMethods acceptedPaymentMethods) {
            this.acceptedPaymentMethods = acceptedPaymentMethods;
            return this;
        }

        public Builder customFields(List<InvoiceCustomField> customFields) {
            this.customFields = OptionalNullable.of(customFields);
            return this;
        }

        public Builder unsetCustomFields() {
            this.customFields = null;
            return this;
        }

        public Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public Builder saleOrServiceDate(String saleOrServiceDate) {
            this.saleOrServiceDate = OptionalNullable.of((Object)saleOrServiceDate);
            return this;
        }

        public Builder unsetSaleOrServiceDate() {
            this.saleOrServiceDate = null;
            return this;
        }

        public Builder paymentConditions(String paymentConditions) {
            this.paymentConditions = OptionalNullable.of((Object)paymentConditions);
            return this;
        }

        public Builder unsetPaymentConditions() {
            this.paymentConditions = null;
            return this;
        }

        public Builder storePaymentMethodEnabled(Boolean storePaymentMethodEnabled) {
            this.storePaymentMethodEnabled = OptionalNullable.of((Object)storePaymentMethodEnabled);
            return this;
        }

        public Builder unsetStorePaymentMethodEnabled() {
            this.storePaymentMethodEnabled = null;
            return this;
        }

        public Builder attachments(List<InvoiceAttachment> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Invoice build() {
            return new Invoice(this.id, this.version, this.locationId, this.orderId, this.primaryRecipient, this.paymentRequests, this.deliveryMethod, this.invoiceNumber, this.title, this.description, this.scheduledAt, this.publicUrl, this.nextPaymentAmountMoney, this.status, this.timezone, this.createdAt, this.updatedAt, this.acceptedPaymentMethods, this.customFields, this.subscriptionId, this.saleOrServiceDate, this.paymentConditions, this.storePaymentMethodEnabled, this.attachments);
        }
    }
}

