/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class InvoiceAttachment {
    private final String id;
    private final String filename;
    private final String description;
    private final Integer filesize;
    private final String hash;
    private final String mimeType;
    private final String uploadedAt;

    @JsonCreator
    public InvoiceAttachment(@JsonProperty(value="id") String id, @JsonProperty(value="filename") String filename, @JsonProperty(value="description") String description, @JsonProperty(value="filesize") Integer filesize, @JsonProperty(value="hash") String hash, @JsonProperty(value="mime_type") String mimeType, @JsonProperty(value="uploaded_at") String uploadedAt) {
        this.id = id;
        this.filename = filename;
        this.description = description;
        this.filesize = filesize;
        this.hash = hash;
        this.mimeType = mimeType;
        this.uploadedAt = uploadedAt;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="filename")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFilename() {
        return this.filename;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonGetter(value="filesize")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getFilesize() {
        return this.filesize;
    }

    @JsonGetter(value="hash")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getHash() {
        return this.hash;
    }

    @JsonGetter(value="mime_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMimeType() {
        return this.mimeType;
    }

    @JsonGetter(value="uploaded_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUploadedAt() {
        return this.uploadedAt;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.filename, this.description, this.filesize, this.hash, this.mimeType, this.uploadedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InvoiceAttachment)) {
            return false;
        }
        InvoiceAttachment other = (InvoiceAttachment)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.filename, other.filename) && Objects.equals(this.description, other.description) && Objects.equals(this.filesize, other.filesize) && Objects.equals(this.hash, other.hash) && Objects.equals(this.mimeType, other.mimeType) && Objects.equals(this.uploadedAt, other.uploadedAt);
    }

    public String toString() {
        return "InvoiceAttachment [id=" + this.id + ", filename=" + this.filename + ", description=" + this.description + ", filesize=" + this.filesize + ", hash=" + this.hash + ", mimeType=" + this.mimeType + ", uploadedAt=" + this.uploadedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).filename(this.getFilename()).description(this.getDescription()).filesize(this.getFilesize()).hash(this.getHash()).mimeType(this.getMimeType()).uploadedAt(this.getUploadedAt());
        return builder;
    }

    public static class Builder {
        private String id;
        private String filename;
        private String description;
        private Integer filesize;
        private String hash;
        private String mimeType;
        private String uploadedAt;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder filesize(Integer filesize) {
            this.filesize = filesize;
            return this;
        }

        public Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public Builder uploadedAt(String uploadedAt) {
            this.uploadedAt = uploadedAt;
            return this;
        }

        public InvoiceAttachment build() {
            return new InvoiceAttachment(this.id, this.filename, this.description, this.filesize, this.hash, this.mimeType, this.uploadedAt);
        }
    }
}

