/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class InvoiceFilter {
    private final List<String> locationIds;
    private final OptionalNullable<List<String>> customerIds;

    @JsonCreator
    public InvoiceFilter(@JsonProperty(value="location_ids") List<String> locationIds, @JsonProperty(value="customer_ids") List<String> customerIds) {
        this.locationIds = locationIds;
        this.customerIds = OptionalNullable.of(customerIds);
    }

    protected InvoiceFilter(List<String> locationIds, OptionalNullable<List<String>> customerIds) {
        this.locationIds = locationIds;
        this.customerIds = customerIds;
    }

    @JsonGetter(value="location_ids")
    public List<String> getLocationIds() {
        return this.locationIds;
    }

    @JsonGetter(value="customer_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetCustomerIds() {
        return this.customerIds;
    }

    @JsonIgnore
    public List<String> getCustomerIds() {
        return (List)OptionalNullable.getFrom(this.customerIds);
    }

    public int hashCode() {
        return Objects.hash(this.locationIds, this.customerIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InvoiceFilter)) {
            return false;
        }
        InvoiceFilter other = (InvoiceFilter)obj;
        return Objects.equals(this.locationIds, other.locationIds) && Objects.equals(this.customerIds, other.customerIds);
    }

    public String toString() {
        return "InvoiceFilter [locationIds=" + this.locationIds + ", customerIds=" + this.customerIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.locationIds);
        builder.customerIds = this.internalGetCustomerIds();
        return builder;
    }

    public static class Builder {
        private List<String> locationIds;
        private OptionalNullable<List<String>> customerIds;

        public Builder(List<String> locationIds) {
            this.locationIds = locationIds;
        }

        public Builder locationIds(List<String> locationIds) {
            this.locationIds = locationIds;
            return this;
        }

        public Builder customerIds(List<String> customerIds) {
            this.customerIds = OptionalNullable.of(customerIds);
            return this;
        }

        public Builder unsetCustomerIds() {
            this.customerIds = null;
            return this;
        }

        public InvoiceFilter build() {
            return new InvoiceFilter(this.locationIds, this.customerIds);
        }
    }
}

