/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ListBookingCustomAttributesRequest {
    private final OptionalNullable<Integer> limit;
    private final OptionalNullable<String> cursor;
    private final OptionalNullable<Boolean> withDefinitions;

    @JsonCreator
    public ListBookingCustomAttributesRequest(@JsonProperty(value="limit") Integer limit, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="with_definitions") Boolean withDefinitions) {
        this.limit = OptionalNullable.of((Object)limit);
        this.cursor = OptionalNullable.of((Object)cursor);
        this.withDefinitions = OptionalNullable.of((Object)withDefinitions);
    }

    protected ListBookingCustomAttributesRequest(OptionalNullable<Integer> limit, OptionalNullable<String> cursor, OptionalNullable<Boolean> withDefinitions) {
        this.limit = limit;
        this.cursor = cursor;
        this.withDefinitions = withDefinitions;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Integer getLimit() {
        return (Integer)OptionalNullable.getFrom(this.limit);
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    @JsonGetter(value="with_definitions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetWithDefinitions() {
        return this.withDefinitions;
    }

    @JsonIgnore
    public Boolean getWithDefinitions() {
        return (Boolean)OptionalNullable.getFrom(this.withDefinitions);
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.cursor, this.withDefinitions);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListBookingCustomAttributesRequest)) {
            return false;
        }
        ListBookingCustomAttributesRequest other = (ListBookingCustomAttributesRequest)obj;
        return Objects.equals(this.limit, other.limit) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.withDefinitions, other.withDefinitions);
    }

    public String toString() {
        return "ListBookingCustomAttributesRequest [limit=" + this.limit + ", cursor=" + this.cursor + ", withDefinitions=" + this.withDefinitions + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.limit = this.internalGetLimit();
        builder.cursor = this.internalGetCursor();
        builder.withDefinitions = this.internalGetWithDefinitions();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<Integer> limit;
        private OptionalNullable<String> cursor;
        private OptionalNullable<Boolean> withDefinitions;

        public Builder limit(Integer limit) {
            this.limit = OptionalNullable.of((Object)limit);
            return this;
        }

        public Builder unsetLimit() {
            this.limit = null;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public Builder withDefinitions(Boolean withDefinitions) {
            this.withDefinitions = OptionalNullable.of((Object)withDefinitions);
            return this;
        }

        public Builder unsetWithDefinitions() {
            this.withDefinitions = null;
            return this;
        }

        public ListBookingCustomAttributesRequest build() {
            return new ListBookingCustomAttributesRequest(this.limit, this.cursor, this.withDefinitions);
        }
    }
}

