/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CashDrawerShiftEvent;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListCashDrawerShiftEventsResponse {
    private HttpContext httpContext;
    private final String cursor;
    private final List<Error> errors;
    private final List<CashDrawerShiftEvent> cashDrawerShiftEvents;

    @JsonCreator
    public ListCashDrawerShiftEventsResponse(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="cash_drawer_shift_events") List<CashDrawerShiftEvent> cashDrawerShiftEvents) {
        this.cursor = cursor;
        this.errors = errors;
        this.cashDrawerShiftEvents = cashDrawerShiftEvents;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="cash_drawer_shift_events")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CashDrawerShiftEvent> getCashDrawerShiftEvents() {
        return this.cashDrawerShiftEvents;
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.errors, this.cashDrawerShiftEvents);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCashDrawerShiftEventsResponse)) {
            return false;
        }
        ListCashDrawerShiftEventsResponse other = (ListCashDrawerShiftEventsResponse)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.errors, other.errors) && Objects.equals(this.cashDrawerShiftEvents, other.cashDrawerShiftEvents);
    }

    public String toString() {
        return "ListCashDrawerShiftEventsResponse [cursor=" + this.cursor + ", errors=" + this.errors + ", cashDrawerShiftEvents=" + this.cashDrawerShiftEvents + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().cursor(this.getCursor()).errors(this.getErrors()).cashDrawerShiftEvents(this.getCashDrawerShiftEvents());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private String cursor;
        private List<Error> errors;
        private List<CashDrawerShiftEvent> cashDrawerShiftEvents;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder cashDrawerShiftEvents(List<CashDrawerShiftEvent> cashDrawerShiftEvents) {
            this.cashDrawerShiftEvents = cashDrawerShiftEvents;
            return this;
        }

        public ListCashDrawerShiftEventsResponse build() {
            ListCashDrawerShiftEventsResponse model = new ListCashDrawerShiftEventsResponse(this.cursor, this.errors, this.cashDrawerShiftEvents);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

