/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ListCashDrawerShiftsRequest {
    private final String locationId;
    private final String sortOrder;
    private final OptionalNullable<String> beginTime;
    private final OptionalNullable<String> endTime;
    private final OptionalNullable<Integer> limit;
    private final OptionalNullable<String> cursor;

    @JsonCreator
    public ListCashDrawerShiftsRequest(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="sort_order") String sortOrder, @JsonProperty(value="begin_time") String beginTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="cursor") String cursor) {
        this.locationId = locationId;
        this.sortOrder = sortOrder;
        this.beginTime = OptionalNullable.of((Object)beginTime);
        this.endTime = OptionalNullable.of((Object)endTime);
        this.limit = OptionalNullable.of((Object)limit);
        this.cursor = OptionalNullable.of((Object)cursor);
    }

    protected ListCashDrawerShiftsRequest(String locationId, String sortOrder, OptionalNullable<String> beginTime, OptionalNullable<String> endTime, OptionalNullable<Integer> limit, OptionalNullable<String> cursor) {
        this.locationId = locationId;
        this.sortOrder = sortOrder;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.limit = limit;
        this.cursor = cursor;
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="sort_order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortOrder() {
        return this.sortOrder;
    }

    @JsonGetter(value="begin_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBeginTime() {
        return this.beginTime;
    }

    @JsonIgnore
    public String getBeginTime() {
        return (String)OptionalNullable.getFrom(this.beginTime);
    }

    @JsonGetter(value="end_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEndTime() {
        return this.endTime;
    }

    @JsonIgnore
    public String getEndTime() {
        return (String)OptionalNullable.getFrom(this.endTime);
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Integer getLimit() {
        return (Integer)OptionalNullable.getFrom(this.limit);
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.sortOrder, this.beginTime, this.endTime, this.limit, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCashDrawerShiftsRequest)) {
            return false;
        }
        ListCashDrawerShiftsRequest other = (ListCashDrawerShiftsRequest)obj;
        return Objects.equals(this.locationId, other.locationId) && Objects.equals(this.sortOrder, other.sortOrder) && Objects.equals(this.beginTime, other.beginTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.limit, other.limit) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListCashDrawerShiftsRequest [locationId=" + this.locationId + ", sortOrder=" + this.sortOrder + ", beginTime=" + this.beginTime + ", endTime=" + this.endTime + ", limit=" + this.limit + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.locationId).sortOrder(this.getSortOrder());
        builder.beginTime = this.internalGetBeginTime();
        builder.endTime = this.internalGetEndTime();
        builder.limit = this.internalGetLimit();
        builder.cursor = this.internalGetCursor();
        return builder;
    }

    public static class Builder {
        private String locationId;
        private String sortOrder;
        private OptionalNullable<String> beginTime;
        private OptionalNullable<String> endTime;
        private OptionalNullable<Integer> limit;
        private OptionalNullable<String> cursor;

        public Builder(String locationId) {
            this.locationId = locationId;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder beginTime(String beginTime) {
            this.beginTime = OptionalNullable.of((Object)beginTime);
            return this;
        }

        public Builder unsetBeginTime() {
            this.beginTime = null;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = OptionalNullable.of((Object)endTime);
            return this;
        }

        public Builder unsetEndTime() {
            this.endTime = null;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = OptionalNullable.of((Object)limit);
            return this;
        }

        public Builder unsetLimit() {
            this.limit = null;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public ListCashDrawerShiftsRequest build() {
            return new ListCashDrawerShiftsRequest(this.locationId, this.sortOrder, this.beginTime, this.endTime, this.limit, this.cursor);
        }
    }
}

