/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CashDrawerShiftSummary;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListCashDrawerShiftsResponse {
    private HttpContext httpContext;
    private final String cursor;
    private final List<Error> errors;
    private final List<CashDrawerShiftSummary> cashDrawerShifts;

    @JsonCreator
    public ListCashDrawerShiftsResponse(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="cash_drawer_shifts") List<CashDrawerShiftSummary> cashDrawerShifts) {
        this.cursor = cursor;
        this.errors = errors;
        this.cashDrawerShifts = cashDrawerShifts;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="cash_drawer_shifts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CashDrawerShiftSummary> getCashDrawerShifts() {
        return this.cashDrawerShifts;
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.errors, this.cashDrawerShifts);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCashDrawerShiftsResponse)) {
            return false;
        }
        ListCashDrawerShiftsResponse other = (ListCashDrawerShiftsResponse)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.errors, other.errors) && Objects.equals(this.cashDrawerShifts, other.cashDrawerShifts);
    }

    public String toString() {
        return "ListCashDrawerShiftsResponse [cursor=" + this.cursor + ", errors=" + this.errors + ", cashDrawerShifts=" + this.cashDrawerShifts + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().cursor(this.getCursor()).errors(this.getErrors()).cashDrawerShifts(this.getCashDrawerShifts());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private String cursor;
        private List<Error> errors;
        private List<CashDrawerShiftSummary> cashDrawerShifts;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder cashDrawerShifts(List<CashDrawerShiftSummary> cashDrawerShifts) {
            this.cashDrawerShifts = cashDrawerShifts;
            return this;
        }

        public ListCashDrawerShiftsResponse build() {
            ListCashDrawerShiftsResponse model = new ListCashDrawerShiftsResponse(this.cursor, this.errors, this.cashDrawerShifts);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

