/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CatalogObject;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListCatalogResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final String cursor;
    private final List<CatalogObject> objects;

    @JsonCreator
    public ListCatalogResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="objects") List<CatalogObject> objects) {
        this.errors = errors;
        this.cursor = cursor;
        this.objects = objects;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="objects")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogObject> getObjects() {
        return this.objects;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.cursor, this.objects);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCatalogResponse)) {
            return false;
        }
        ListCatalogResponse other = (ListCatalogResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.objects, other.objects);
    }

    public String toString() {
        return "ListCatalogResponse [errors=" + this.errors + ", cursor=" + this.cursor + ", objects=" + this.objects + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).cursor(this.getCursor()).objects(this.getObjects());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private String cursor;
        private List<CatalogObject> objects;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder objects(List<CatalogObject> objects) {
            this.objects = objects;
            return this;
        }

        public ListCatalogResponse build() {
            ListCatalogResponse model = new ListCatalogResponse(this.errors, this.cursor, this.objects);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

