/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CustomerSegment;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListCustomerSegmentsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<CustomerSegment> segments;
    private final String cursor;

    @JsonCreator
    public ListCustomerSegmentsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="segments") List<CustomerSegment> segments, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.segments = segments;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="segments")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CustomerSegment> getSegments() {
        return this.segments;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.segments, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListCustomerSegmentsResponse)) {
            return false;
        }
        ListCustomerSegmentsResponse other = (ListCustomerSegmentsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.segments, other.segments) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListCustomerSegmentsResponse [errors=" + this.errors + ", segments=" + this.segments + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).segments(this.getSegments()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<CustomerSegment> segments;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder segments(List<CustomerSegment> segments) {
            this.segments = segments;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListCustomerSegmentsResponse build() {
            ListCustomerSegmentsResponse model = new ListCustomerSegmentsResponse(this.errors, this.segments, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

