/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class ListDeviceCodesRequest {
    private final OptionalNullable<String> cursor;
    private final OptionalNullable<String> locationId;
    private final String productType;
    private final OptionalNullable<List<String>> status;

    @JsonCreator
    public ListDeviceCodesRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="product_type") String productType, @JsonProperty(value="status") List<String> status) {
        this.cursor = OptionalNullable.of((Object)cursor);
        this.locationId = OptionalNullable.of((Object)locationId);
        this.productType = productType;
        this.status = OptionalNullable.of(status);
    }

    protected ListDeviceCodesRequest(OptionalNullable<String> cursor, OptionalNullable<String> locationId, String productType, OptionalNullable<List<String>> status) {
        this.cursor = cursor;
        this.locationId = locationId;
        this.productType = productType;
        this.status = status;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    @JsonGetter(value="product_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getProductType() {
        return this.productType;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetStatus() {
        return this.status;
    }

    @JsonIgnore
    public List<String> getStatus() {
        return (List)OptionalNullable.getFrom(this.status);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.locationId, this.productType, this.status);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListDeviceCodesRequest)) {
            return false;
        }
        ListDeviceCodesRequest other = (ListDeviceCodesRequest)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.productType, other.productType) && Objects.equals(this.status, other.status);
    }

    public String toString() {
        return "ListDeviceCodesRequest [cursor=" + this.cursor + ", locationId=" + this.locationId + ", productType=" + this.productType + ", status=" + this.status + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().productType(this.getProductType());
        builder.cursor = this.internalGetCursor();
        builder.locationId = this.internalGetLocationId();
        builder.status = this.internalGetStatus();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> cursor;
        private OptionalNullable<String> locationId;
        private String productType;
        private OptionalNullable<List<String>> status;

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        public Builder status(List<String> status) {
            this.status = OptionalNullable.of(status);
            return this;
        }

        public Builder unsetStatus() {
            this.status = null;
            return this;
        }

        public ListDeviceCodesRequest build() {
            return new ListDeviceCodesRequest(this.cursor, this.locationId, this.productType, this.status);
        }
    }
}

