/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ListDevicesRequest {
    private final OptionalNullable<String> cursor;
    private final String sortOrder;
    private final OptionalNullable<Integer> limit;
    private final OptionalNullable<String> locationId;

    @JsonCreator
    public ListDevicesRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="sort_order") String sortOrder, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="location_id") String locationId) {
        this.cursor = OptionalNullable.of((Object)cursor);
        this.sortOrder = sortOrder;
        this.limit = OptionalNullable.of((Object)limit);
        this.locationId = OptionalNullable.of((Object)locationId);
    }

    protected ListDevicesRequest(OptionalNullable<String> cursor, String sortOrder, OptionalNullable<Integer> limit, OptionalNullable<String> locationId) {
        this.cursor = cursor;
        this.sortOrder = sortOrder;
        this.limit = limit;
        this.locationId = locationId;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    @JsonGetter(value="sort_order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortOrder() {
        return this.sortOrder;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Integer getLimit() {
        return (Integer)OptionalNullable.getFrom(this.limit);
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.sortOrder, this.limit, this.locationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListDevicesRequest)) {
            return false;
        }
        ListDevicesRequest other = (ListDevicesRequest)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.sortOrder, other.sortOrder) && Objects.equals(this.limit, other.limit) && Objects.equals(this.locationId, other.locationId);
    }

    public String toString() {
        return "ListDevicesRequest [cursor=" + this.cursor + ", sortOrder=" + this.sortOrder + ", limit=" + this.limit + ", locationId=" + this.locationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().sortOrder(this.getSortOrder());
        builder.cursor = this.internalGetCursor();
        builder.limit = this.internalGetLimit();
        builder.locationId = this.internalGetLocationId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> cursor;
        private String sortOrder;
        private OptionalNullable<Integer> limit;
        private OptionalNullable<String> locationId;

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = OptionalNullable.of((Object)limit);
            return this;
        }

        public Builder unsetLimit() {
            this.limit = null;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public ListDevicesRequest build() {
            return new ListDevicesRequest(this.cursor, this.sortOrder, this.limit, this.locationId);
        }
    }
}

