/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Device;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListDevicesResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<Device> devices;
    private final String cursor;

    @JsonCreator
    public ListDevicesResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="devices") List<Device> devices, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.devices = devices;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="devices")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Device> getDevices() {
        return this.devices;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.devices, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListDevicesResponse)) {
            return false;
        }
        ListDevicesResponse other = (ListDevicesResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.devices, other.devices) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListDevicesResponse [errors=" + this.errors + ", devices=" + this.devices + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).devices(this.getDevices()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<Device> devices;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder devices(List<Device> devices) {
            this.devices = devices;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListDevicesResponse build() {
            ListDevicesResponse model = new ListDevicesResponse(this.errors, this.devices, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

