/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class ListDisputesRequest {
    private final OptionalNullable<String> cursor;
    private final OptionalNullable<List<String>> states;
    private final OptionalNullable<String> locationId;

    @JsonCreator
    public ListDisputesRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="states") List<String> states, @JsonProperty(value="location_id") String locationId) {
        this.cursor = OptionalNullable.of((Object)cursor);
        this.states = OptionalNullable.of(states);
        this.locationId = OptionalNullable.of((Object)locationId);
    }

    protected ListDisputesRequest(OptionalNullable<String> cursor, OptionalNullable<List<String>> states, OptionalNullable<String> locationId) {
        this.cursor = cursor;
        this.states = states;
        this.locationId = locationId;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    @JsonGetter(value="states")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetStates() {
        return this.states;
    }

    @JsonIgnore
    public List<String> getStates() {
        return (List)OptionalNullable.getFrom(this.states);
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.states, this.locationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListDisputesRequest)) {
            return false;
        }
        ListDisputesRequest other = (ListDisputesRequest)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.states, other.states) && Objects.equals(this.locationId, other.locationId);
    }

    public String toString() {
        return "ListDisputesRequest [cursor=" + this.cursor + ", states=" + this.states + ", locationId=" + this.locationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.cursor = this.internalGetCursor();
        builder.states = this.internalGetStates();
        builder.locationId = this.internalGetLocationId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> cursor;
        private OptionalNullable<List<String>> states;
        private OptionalNullable<String> locationId;

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public Builder states(List<String> states) {
            this.states = OptionalNullable.of(states);
            return this;
        }

        public Builder unsetStates() {
            this.states = null;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public ListDisputesRequest build() {
            return new ListDisputesRequest(this.cursor, this.states, this.locationId);
        }
    }
}

