/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Dispute;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListDisputesResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<Dispute> disputes;
    private final String cursor;

    @JsonCreator
    public ListDisputesResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="disputes") List<Dispute> disputes, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.disputes = disputes;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="disputes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Dispute> getDisputes() {
        return this.disputes;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.disputes, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListDisputesResponse)) {
            return false;
        }
        ListDisputesResponse other = (ListDisputesResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.disputes, other.disputes) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListDisputesResponse [errors=" + this.errors + ", disputes=" + this.disputes + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).disputes(this.getDisputes()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<Dispute> disputes;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder disputes(List<Dispute> disputes) {
            this.disputes = disputes;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListDisputesResponse build() {
            ListDisputesResponse model = new ListDisputesResponse(this.errors, this.disputes, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

