/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ListEmployeesRequest {
    private final OptionalNullable<String> locationId;
    private final String status;
    private final OptionalNullable<Integer> limit;
    private final OptionalNullable<String> cursor;

    @JsonCreator
    public ListEmployeesRequest(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="status") String status, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="cursor") String cursor) {
        this.locationId = OptionalNullable.of((Object)locationId);
        this.status = status;
        this.limit = OptionalNullable.of((Object)limit);
        this.cursor = OptionalNullable.of((Object)cursor);
    }

    protected ListEmployeesRequest(OptionalNullable<String> locationId, String status, OptionalNullable<Integer> limit, OptionalNullable<String> cursor) {
        this.locationId = locationId;
        this.status = status;
        this.limit = limit;
        this.cursor = cursor;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Integer getLimit() {
        return (Integer)OptionalNullable.getFrom(this.limit);
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.status, this.limit, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListEmployeesRequest)) {
            return false;
        }
        ListEmployeesRequest other = (ListEmployeesRequest)obj;
        return Objects.equals(this.locationId, other.locationId) && Objects.equals(this.status, other.status) && Objects.equals(this.limit, other.limit) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListEmployeesRequest [locationId=" + this.locationId + ", status=" + this.status + ", limit=" + this.limit + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().status(this.getStatus());
        builder.locationId = this.internalGetLocationId();
        builder.limit = this.internalGetLimit();
        builder.cursor = this.internalGetCursor();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> locationId;
        private String status;
        private OptionalNullable<Integer> limit;
        private OptionalNullable<String> cursor;

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = OptionalNullable.of((Object)limit);
            return this;
        }

        public Builder unsetLimit() {
            this.limit = null;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public ListEmployeesRequest build() {
            return new ListEmployeesRequest(this.locationId, this.status, this.limit, this.cursor);
        }
    }
}

