/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Employee;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class ListEmployeesResponse {
    private HttpContext httpContext;
    private final List<Employee> employees;
    private final String cursor;
    private final List<Error> errors;

    @JsonCreator
    public ListEmployeesResponse(@JsonProperty(value="employees") List<Employee> employees, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="errors") List<Error> errors) {
        this.employees = employees;
        this.cursor = cursor;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="employees")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Employee> getEmployees() {
        return this.employees;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.employees, this.cursor, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListEmployeesResponse)) {
            return false;
        }
        ListEmployeesResponse other = (ListEmployeesResponse)obj;
        return Objects.equals(this.employees, other.employees) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "ListEmployeesResponse [employees=" + this.employees + ", cursor=" + this.cursor + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().employees(this.getEmployees()).cursor(this.getCursor()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Employee> employees;
        private String cursor;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder employees(List<Employee> employees) {
            this.employees = employees;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public ListEmployeesResponse build() {
            ListEmployeesResponse model = new ListEmployeesResponse(this.employees, this.cursor, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

