/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.LocationBookingProfile;
import java.util.List;
import java.util.Objects;

public class ListLocationBookingProfilesResponse {
    private HttpContext httpContext;
    private final List<LocationBookingProfile> locationBookingProfiles;
    private final String cursor;
    private final List<Error> errors;

    @JsonCreator
    public ListLocationBookingProfilesResponse(@JsonProperty(value="location_booking_profiles") List<LocationBookingProfile> locationBookingProfiles, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="errors") List<Error> errors) {
        this.locationBookingProfiles = locationBookingProfiles;
        this.cursor = cursor;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="location_booking_profiles")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<LocationBookingProfile> getLocationBookingProfiles() {
        return this.locationBookingProfiles;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.locationBookingProfiles, this.cursor, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListLocationBookingProfilesResponse)) {
            return false;
        }
        ListLocationBookingProfilesResponse other = (ListLocationBookingProfilesResponse)obj;
        return Objects.equals(this.locationBookingProfiles, other.locationBookingProfiles) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "ListLocationBookingProfilesResponse [locationBookingProfiles=" + this.locationBookingProfiles + ", cursor=" + this.cursor + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().locationBookingProfiles(this.getLocationBookingProfiles()).cursor(this.getCursor()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<LocationBookingProfile> locationBookingProfiles;
        private String cursor;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder locationBookingProfiles(List<LocationBookingProfile> locationBookingProfiles) {
            this.locationBookingProfiles = locationBookingProfiles;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public ListLocationBookingProfilesResponse build() {
            ListLocationBookingProfilesResponse model = new ListLocationBookingProfilesResponse(this.locationBookingProfiles, this.cursor, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

