/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ListRefundsRequest {
    private final OptionalNullable<String> beginTime;
    private final OptionalNullable<String> endTime;
    private final String sortOrder;
    private final OptionalNullable<String> cursor;

    @JsonCreator
    public ListRefundsRequest(@JsonProperty(value="begin_time") String beginTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="sort_order") String sortOrder, @JsonProperty(value="cursor") String cursor) {
        this.beginTime = OptionalNullable.of((Object)beginTime);
        this.endTime = OptionalNullable.of((Object)endTime);
        this.sortOrder = sortOrder;
        this.cursor = OptionalNullable.of((Object)cursor);
    }

    protected ListRefundsRequest(OptionalNullable<String> beginTime, OptionalNullable<String> endTime, String sortOrder, OptionalNullable<String> cursor) {
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.sortOrder = sortOrder;
        this.cursor = cursor;
    }

    @JsonGetter(value="begin_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBeginTime() {
        return this.beginTime;
    }

    @JsonIgnore
    public String getBeginTime() {
        return (String)OptionalNullable.getFrom(this.beginTime);
    }

    @JsonGetter(value="end_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEndTime() {
        return this.endTime;
    }

    @JsonIgnore
    public String getEndTime() {
        return (String)OptionalNullable.getFrom(this.endTime);
    }

    @JsonGetter(value="sort_order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortOrder() {
        return this.sortOrder;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.beginTime, this.endTime, this.sortOrder, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListRefundsRequest)) {
            return false;
        }
        ListRefundsRequest other = (ListRefundsRequest)obj;
        return Objects.equals(this.beginTime, other.beginTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.sortOrder, other.sortOrder) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListRefundsRequest [beginTime=" + this.beginTime + ", endTime=" + this.endTime + ", sortOrder=" + this.sortOrder + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().sortOrder(this.getSortOrder());
        builder.beginTime = this.internalGetBeginTime();
        builder.endTime = this.internalGetEndTime();
        builder.cursor = this.internalGetCursor();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> beginTime;
        private OptionalNullable<String> endTime;
        private String sortOrder;
        private OptionalNullable<String> cursor;

        public Builder beginTime(String beginTime) {
            this.beginTime = OptionalNullable.of((Object)beginTime);
            return this;
        }

        public Builder unsetBeginTime() {
            this.beginTime = null;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = OptionalNullable.of((Object)endTime);
            return this;
        }

        public Builder unsetEndTime() {
            this.endTime = null;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public ListRefundsRequest build() {
            return new ListRefundsRequest(this.beginTime, this.endTime, this.sortOrder, this.cursor);
        }
    }
}

