/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Error;
import com.squareup.square.models.Refund;
import java.util.List;
import java.util.Objects;

public class ListRefundsResponse {
    private final List<Error> errors;
    private final List<Refund> refunds;
    private final String cursor;

    @JsonCreator
    public ListRefundsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="refunds") List<Refund> refunds, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.refunds = refunds;
        this.cursor = cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="refunds")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Refund> getRefunds() {
        return this.refunds;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.refunds, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListRefundsResponse)) {
            return false;
        }
        ListRefundsResponse other = (ListRefundsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.refunds, other.refunds) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListRefundsResponse [errors=" + this.errors + ", refunds=" + this.refunds + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).refunds(this.getRefunds()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private List<Error> errors;
        private List<Refund> refunds;
        private String cursor;

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder refunds(List<Refund> refunds) {
            this.refunds = refunds;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListRefundsResponse build() {
            return new ListRefundsResponse(this.errors, this.refunds, this.cursor);
        }
    }
}

