/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.TeamMemberWage;
import java.util.List;
import java.util.Objects;

public class ListTeamMemberWagesResponse {
    private HttpContext httpContext;
    private final List<TeamMemberWage> teamMemberWages;
    private final String cursor;
    private final List<Error> errors;

    @JsonCreator
    public ListTeamMemberWagesResponse(@JsonProperty(value="team_member_wages") List<TeamMemberWage> teamMemberWages, @JsonProperty(value="cursor") String cursor, @JsonProperty(value="errors") List<Error> errors) {
        this.teamMemberWages = teamMemberWages;
        this.cursor = cursor;
        this.errors = errors;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="team_member_wages")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<TeamMemberWage> getTeamMemberWages() {
        return this.teamMemberWages;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.teamMemberWages, this.cursor, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListTeamMemberWagesResponse)) {
            return false;
        }
        ListTeamMemberWagesResponse other = (ListTeamMemberWagesResponse)obj;
        return Objects.equals(this.teamMemberWages, other.teamMemberWages) && Objects.equals(this.cursor, other.cursor) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "ListTeamMemberWagesResponse [teamMemberWages=" + this.teamMemberWages + ", cursor=" + this.cursor + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().teamMemberWages(this.getTeamMemberWages()).cursor(this.getCursor()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<TeamMemberWage> teamMemberWages;
        private String cursor;
        private List<Error> errors;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder teamMemberWages(List<TeamMemberWage> teamMemberWages) {
            this.teamMemberWages = teamMemberWages;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public ListTeamMemberWagesResponse build() {
            ListTeamMemberWagesResponse model = new ListTeamMemberWagesResponse(this.teamMemberWages, this.cursor, this.errors);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

