/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.Transaction;
import java.util.List;
import java.util.Objects;

public class ListTransactionsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<Transaction> transactions;
    private final String cursor;

    @JsonCreator
    public ListTransactionsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="transactions") List<Transaction> transactions, @JsonProperty(value="cursor") String cursor) {
        this.errors = errors;
        this.transactions = transactions;
        this.cursor = cursor;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="transactions")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.transactions, this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListTransactionsResponse)) {
            return false;
        }
        ListTransactionsResponse other = (ListTransactionsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.transactions, other.transactions) && Objects.equals(this.cursor, other.cursor);
    }

    public String toString() {
        return "ListTransactionsResponse [errors=" + this.errors + ", transactions=" + this.transactions + ", cursor=" + this.cursor + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).transactions(this.getTransactions()).cursor(this.getCursor());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<Transaction> transactions;
        private String cursor;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder transactions(List<Transaction> transactions) {
            this.transactions = transactions;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public ListTransactionsResponse build() {
            ListTransactionsResponse model = new ListTransactionsResponse(this.errors, this.transactions, this.cursor);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

