/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.EventTypeMetadata;
import java.util.List;
import java.util.Objects;

public class ListWebhookEventTypesResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<String> eventTypes;
    private final List<EventTypeMetadata> metadata;

    @JsonCreator
    public ListWebhookEventTypesResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="event_types") List<String> eventTypes, @JsonProperty(value="metadata") List<EventTypeMetadata> metadata) {
        this.errors = errors;
        this.eventTypes = eventTypes;
        this.metadata = metadata;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="event_types")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getEventTypes() {
        return this.eventTypes;
    }

    @JsonGetter(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<EventTypeMetadata> getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.eventTypes, this.metadata);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListWebhookEventTypesResponse)) {
            return false;
        }
        ListWebhookEventTypesResponse other = (ListWebhookEventTypesResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.eventTypes, other.eventTypes) && Objects.equals(this.metadata, other.metadata);
    }

    public String toString() {
        return "ListWebhookEventTypesResponse [errors=" + this.errors + ", eventTypes=" + this.eventTypes + ", metadata=" + this.metadata + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).eventTypes(this.getEventTypes()).metadata(this.getMetadata());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<String> eventTypes;
        private List<EventTypeMetadata> metadata;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder eventTypes(List<String> eventTypes) {
            this.eventTypes = eventTypes;
            return this;
        }

        public Builder metadata(List<EventTypeMetadata> metadata) {
            this.metadata = metadata;
            return this;
        }

        public ListWebhookEventTypesResponse build() {
            ListWebhookEventTypesResponse model = new ListWebhookEventTypesResponse(this.errors, this.eventTypes, this.metadata);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

