/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class ListWebhookSubscriptionsRequest {
    private final OptionalNullable<String> cursor;
    private final OptionalNullable<Boolean> includeDisabled;
    private final String sortOrder;
    private final OptionalNullable<Integer> limit;

    @JsonCreator
    public ListWebhookSubscriptionsRequest(@JsonProperty(value="cursor") String cursor, @JsonProperty(value="include_disabled") Boolean includeDisabled, @JsonProperty(value="sort_order") String sortOrder, @JsonProperty(value="limit") Integer limit) {
        this.cursor = OptionalNullable.of((Object)cursor);
        this.includeDisabled = OptionalNullable.of((Object)includeDisabled);
        this.sortOrder = sortOrder;
        this.limit = OptionalNullable.of((Object)limit);
    }

    protected ListWebhookSubscriptionsRequest(OptionalNullable<String> cursor, OptionalNullable<Boolean> includeDisabled, String sortOrder, OptionalNullable<Integer> limit) {
        this.cursor = cursor;
        this.includeDisabled = includeDisabled;
        this.sortOrder = sortOrder;
        this.limit = limit;
    }

    @JsonGetter(value="cursor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCursor() {
        return this.cursor;
    }

    @JsonIgnore
    public String getCursor() {
        return (String)OptionalNullable.getFrom(this.cursor);
    }

    @JsonGetter(value="include_disabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIncludeDisabled() {
        return this.includeDisabled;
    }

    @JsonIgnore
    public Boolean getIncludeDisabled() {
        return (Boolean)OptionalNullable.getFrom(this.includeDisabled);
    }

    @JsonGetter(value="sort_order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSortOrder() {
        return this.sortOrder;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetLimit() {
        return this.limit;
    }

    @JsonIgnore
    public Integer getLimit() {
        return (Integer)OptionalNullable.getFrom(this.limit);
    }

    public int hashCode() {
        return Objects.hash(this.cursor, this.includeDisabled, this.sortOrder, this.limit);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ListWebhookSubscriptionsRequest)) {
            return false;
        }
        ListWebhookSubscriptionsRequest other = (ListWebhookSubscriptionsRequest)obj;
        return Objects.equals(this.cursor, other.cursor) && Objects.equals(this.includeDisabled, other.includeDisabled) && Objects.equals(this.sortOrder, other.sortOrder) && Objects.equals(this.limit, other.limit);
    }

    public String toString() {
        return "ListWebhookSubscriptionsRequest [cursor=" + this.cursor + ", includeDisabled=" + this.includeDisabled + ", sortOrder=" + this.sortOrder + ", limit=" + this.limit + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().sortOrder(this.getSortOrder());
        builder.cursor = this.internalGetCursor();
        builder.includeDisabled = this.internalGetIncludeDisabled();
        builder.limit = this.internalGetLimit();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> cursor;
        private OptionalNullable<Boolean> includeDisabled;
        private String sortOrder;
        private OptionalNullable<Integer> limit;

        public Builder cursor(String cursor) {
            this.cursor = OptionalNullable.of((Object)cursor);
            return this;
        }

        public Builder unsetCursor() {
            this.cursor = null;
            return this;
        }

        public Builder includeDisabled(Boolean includeDisabled) {
            this.includeDisabled = OptionalNullable.of((Object)includeDisabled);
            return this;
        }

        public Builder unsetIncludeDisabled() {
            this.includeDisabled = null;
            return this;
        }

        public Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = OptionalNullable.of((Object)limit);
            return this;
        }

        public Builder unsetLimit() {
            this.limit = null;
            return this;
        }

        public ListWebhookSubscriptionsRequest build() {
            return new ListWebhookSubscriptionsRequest(this.cursor, this.includeDisabled, this.sortOrder, this.limit);
        }
    }
}

