/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class LocationBookingProfile {
    private final OptionalNullable<String> locationId;
    private final OptionalNullable<String> bookingSiteUrl;
    private final OptionalNullable<Boolean> onlineBookingEnabled;

    @JsonCreator
    public LocationBookingProfile(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="booking_site_url") String bookingSiteUrl, @JsonProperty(value="online_booking_enabled") Boolean onlineBookingEnabled) {
        this.locationId = OptionalNullable.of((Object)locationId);
        this.bookingSiteUrl = OptionalNullable.of((Object)bookingSiteUrl);
        this.onlineBookingEnabled = OptionalNullable.of((Object)onlineBookingEnabled);
    }

    protected LocationBookingProfile(OptionalNullable<String> locationId, OptionalNullable<String> bookingSiteUrl, OptionalNullable<Boolean> onlineBookingEnabled) {
        this.locationId = locationId;
        this.bookingSiteUrl = bookingSiteUrl;
        this.onlineBookingEnabled = onlineBookingEnabled;
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    @JsonGetter(value="booking_site_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBookingSiteUrl() {
        return this.bookingSiteUrl;
    }

    @JsonIgnore
    public String getBookingSiteUrl() {
        return (String)OptionalNullable.getFrom(this.bookingSiteUrl);
    }

    @JsonGetter(value="online_booking_enabled")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetOnlineBookingEnabled() {
        return this.onlineBookingEnabled;
    }

    @JsonIgnore
    public Boolean getOnlineBookingEnabled() {
        return (Boolean)OptionalNullable.getFrom(this.onlineBookingEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.bookingSiteUrl, this.onlineBookingEnabled);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LocationBookingProfile)) {
            return false;
        }
        LocationBookingProfile other = (LocationBookingProfile)obj;
        return Objects.equals(this.locationId, other.locationId) && Objects.equals(this.bookingSiteUrl, other.bookingSiteUrl) && Objects.equals(this.onlineBookingEnabled, other.onlineBookingEnabled);
    }

    public String toString() {
        return "LocationBookingProfile [locationId=" + this.locationId + ", bookingSiteUrl=" + this.bookingSiteUrl + ", onlineBookingEnabled=" + this.onlineBookingEnabled + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.locationId = this.internalGetLocationId();
        builder.bookingSiteUrl = this.internalGetBookingSiteUrl();
        builder.onlineBookingEnabled = this.internalGetOnlineBookingEnabled();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> locationId;
        private OptionalNullable<String> bookingSiteUrl;
        private OptionalNullable<Boolean> onlineBookingEnabled;

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Builder bookingSiteUrl(String bookingSiteUrl) {
            this.bookingSiteUrl = OptionalNullable.of((Object)bookingSiteUrl);
            return this;
        }

        public Builder unsetBookingSiteUrl() {
            this.bookingSiteUrl = null;
            return this;
        }

        public Builder onlineBookingEnabled(Boolean onlineBookingEnabled) {
            this.onlineBookingEnabled = OptionalNullable.of((Object)onlineBookingEnabled);
            return this;
        }

        public Builder unsetOnlineBookingEnabled() {
            this.onlineBookingEnabled = null;
            return this;
        }

        public LocationBookingProfile build() {
            return new LocationBookingProfile(this.locationId, this.bookingSiteUrl, this.onlineBookingEnabled);
        }
    }
}

