/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class LoyaltyEventAccumulatePromotionPoints {
    private final String loyaltyProgramId;
    private final String loyaltyPromotionId;
    private final int points;
    private final String orderId;

    @JsonCreator
    public LoyaltyEventAccumulatePromotionPoints(@JsonProperty(value="points") int points, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="loyalty_program_id") String loyaltyProgramId, @JsonProperty(value="loyalty_promotion_id") String loyaltyPromotionId) {
        this.loyaltyProgramId = loyaltyProgramId;
        this.loyaltyPromotionId = loyaltyPromotionId;
        this.points = points;
        this.orderId = orderId;
    }

    @JsonGetter(value="loyalty_program_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLoyaltyProgramId() {
        return this.loyaltyProgramId;
    }

    @JsonGetter(value="loyalty_promotion_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLoyaltyPromotionId() {
        return this.loyaltyPromotionId;
    }

    @JsonGetter(value="points")
    public int getPoints() {
        return this.points;
    }

    @JsonGetter(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    public int hashCode() {
        return Objects.hash(this.loyaltyProgramId, this.loyaltyPromotionId, this.points, this.orderId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyEventAccumulatePromotionPoints)) {
            return false;
        }
        LoyaltyEventAccumulatePromotionPoints other = (LoyaltyEventAccumulatePromotionPoints)obj;
        return Objects.equals(this.loyaltyProgramId, other.loyaltyProgramId) && Objects.equals(this.loyaltyPromotionId, other.loyaltyPromotionId) && Objects.equals(this.points, other.points) && Objects.equals(this.orderId, other.orderId);
    }

    public String toString() {
        return "LoyaltyEventAccumulatePromotionPoints [points=" + this.points + ", orderId=" + this.orderId + ", loyaltyProgramId=" + this.loyaltyProgramId + ", loyaltyPromotionId=" + this.loyaltyPromotionId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.points, this.orderId).loyaltyProgramId(this.getLoyaltyProgramId()).loyaltyPromotionId(this.getLoyaltyPromotionId());
        return builder;
    }

    public static class Builder {
        private int points;
        private String orderId;
        private String loyaltyProgramId;
        private String loyaltyPromotionId;

        public Builder(int points, String orderId) {
            this.points = points;
            this.orderId = orderId;
        }

        public Builder points(int points) {
            this.points = points;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder loyaltyProgramId(String loyaltyProgramId) {
            this.loyaltyProgramId = loyaltyProgramId;
            return this;
        }

        public Builder loyaltyPromotionId(String loyaltyPromotionId) {
            this.loyaltyPromotionId = loyaltyPromotionId;
            return this;
        }

        public LoyaltyEventAccumulatePromotionPoints build() {
            return new LoyaltyEventAccumulatePromotionPoints(this.points, this.orderId, this.loyaltyProgramId, this.loyaltyPromotionId);
        }
    }
}

