/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class LoyaltyEventAdjustPoints {
    private final String loyaltyProgramId;
    private final int points;
    private final OptionalNullable<String> reason;

    @JsonCreator
    public LoyaltyEventAdjustPoints(@JsonProperty(value="points") int points, @JsonProperty(value="loyalty_program_id") String loyaltyProgramId, @JsonProperty(value="reason") String reason) {
        this.loyaltyProgramId = loyaltyProgramId;
        this.points = points;
        this.reason = OptionalNullable.of((Object)reason);
    }

    protected LoyaltyEventAdjustPoints(int points, String loyaltyProgramId, OptionalNullable<String> reason) {
        this.loyaltyProgramId = loyaltyProgramId;
        this.points = points;
        this.reason = reason;
    }

    @JsonGetter(value="loyalty_program_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLoyaltyProgramId() {
        return this.loyaltyProgramId;
    }

    @JsonGetter(value="points")
    public int getPoints() {
        return this.points;
    }

    @JsonGetter(value="reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetReason() {
        return this.reason;
    }

    @JsonIgnore
    public String getReason() {
        return (String)OptionalNullable.getFrom(this.reason);
    }

    public int hashCode() {
        return Objects.hash(this.loyaltyProgramId, this.points, this.reason);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyEventAdjustPoints)) {
            return false;
        }
        LoyaltyEventAdjustPoints other = (LoyaltyEventAdjustPoints)obj;
        return Objects.equals(this.loyaltyProgramId, other.loyaltyProgramId) && Objects.equals(this.points, other.points) && Objects.equals(this.reason, other.reason);
    }

    public String toString() {
        return "LoyaltyEventAdjustPoints [points=" + this.points + ", loyaltyProgramId=" + this.loyaltyProgramId + ", reason=" + this.reason + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.points).loyaltyProgramId(this.getLoyaltyProgramId());
        builder.reason = this.internalGetReason();
        return builder;
    }

    public static class Builder {
        private int points;
        private String loyaltyProgramId;
        private OptionalNullable<String> reason;

        public Builder(int points) {
            this.points = points;
        }

        public Builder points(int points) {
            this.points = points;
            return this;
        }

        public Builder loyaltyProgramId(String loyaltyProgramId) {
            this.loyaltyProgramId = loyaltyProgramId;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = OptionalNullable.of((Object)reason);
            return this;
        }

        public Builder unsetReason() {
            this.reason = null;
            return this;
        }

        public LoyaltyEventAdjustPoints build() {
            return new LoyaltyEventAdjustPoints(this.points, this.loyaltyProgramId, this.reason);
        }
    }
}

