/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class LoyaltyEventRedeemReward {
    private final String loyaltyProgramId;
    private final String rewardId;
    private final String orderId;

    @JsonCreator
    public LoyaltyEventRedeemReward(@JsonProperty(value="loyalty_program_id") String loyaltyProgramId, @JsonProperty(value="reward_id") String rewardId, @JsonProperty(value="order_id") String orderId) {
        this.loyaltyProgramId = loyaltyProgramId;
        this.rewardId = rewardId;
        this.orderId = orderId;
    }

    @JsonGetter(value="loyalty_program_id")
    public String getLoyaltyProgramId() {
        return this.loyaltyProgramId;
    }

    @JsonGetter(value="reward_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRewardId() {
        return this.rewardId;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrderId() {
        return this.orderId;
    }

    public int hashCode() {
        return Objects.hash(this.loyaltyProgramId, this.rewardId, this.orderId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyEventRedeemReward)) {
            return false;
        }
        LoyaltyEventRedeemReward other = (LoyaltyEventRedeemReward)obj;
        return Objects.equals(this.loyaltyProgramId, other.loyaltyProgramId) && Objects.equals(this.rewardId, other.rewardId) && Objects.equals(this.orderId, other.orderId);
    }

    public String toString() {
        return "LoyaltyEventRedeemReward [loyaltyProgramId=" + this.loyaltyProgramId + ", rewardId=" + this.rewardId + ", orderId=" + this.orderId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.loyaltyProgramId).rewardId(this.getRewardId()).orderId(this.getOrderId());
        return builder;
    }

    public static class Builder {
        private String loyaltyProgramId;
        private String rewardId;
        private String orderId;

        public Builder(String loyaltyProgramId) {
            this.loyaltyProgramId = loyaltyProgramId;
        }

        public Builder loyaltyProgramId(String loyaltyProgramId) {
            this.loyaltyProgramId = loyaltyProgramId;
            return this;
        }

        public Builder rewardId(String rewardId) {
            this.rewardId = rewardId;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public LoyaltyEventRedeemReward build() {
            return new LoyaltyEventRedeemReward(this.loyaltyProgramId, this.rewardId, this.orderId);
        }
    }
}

