/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class LoyaltyProgramAccrualRuleSpendData {
    private final Money amountMoney;
    private final OptionalNullable<List<String>> excludedCategoryIds;
    private final OptionalNullable<List<String>> excludedItemVariationIds;
    private final String taxMode;

    @JsonCreator
    public LoyaltyProgramAccrualRuleSpendData(@JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="tax_mode") String taxMode, @JsonProperty(value="excluded_category_ids") List<String> excludedCategoryIds, @JsonProperty(value="excluded_item_variation_ids") List<String> excludedItemVariationIds) {
        this.amountMoney = amountMoney;
        this.excludedCategoryIds = OptionalNullable.of(excludedCategoryIds);
        this.excludedItemVariationIds = OptionalNullable.of(excludedItemVariationIds);
        this.taxMode = taxMode;
    }

    protected LoyaltyProgramAccrualRuleSpendData(Money amountMoney, String taxMode, OptionalNullable<List<String>> excludedCategoryIds, OptionalNullable<List<String>> excludedItemVariationIds) {
        this.amountMoney = amountMoney;
        this.excludedCategoryIds = excludedCategoryIds;
        this.excludedItemVariationIds = excludedItemVariationIds;
        this.taxMode = taxMode;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="excluded_category_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetExcludedCategoryIds() {
        return this.excludedCategoryIds;
    }

    @JsonIgnore
    public List<String> getExcludedCategoryIds() {
        return (List)OptionalNullable.getFrom(this.excludedCategoryIds);
    }

    @JsonGetter(value="excluded_item_variation_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetExcludedItemVariationIds() {
        return this.excludedItemVariationIds;
    }

    @JsonIgnore
    public List<String> getExcludedItemVariationIds() {
        return (List)OptionalNullable.getFrom(this.excludedItemVariationIds);
    }

    @JsonGetter(value="tax_mode")
    public String getTaxMode() {
        return this.taxMode;
    }

    public int hashCode() {
        return Objects.hash(this.amountMoney, this.excludedCategoryIds, this.excludedItemVariationIds, this.taxMode);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyProgramAccrualRuleSpendData)) {
            return false;
        }
        LoyaltyProgramAccrualRuleSpendData other = (LoyaltyProgramAccrualRuleSpendData)obj;
        return Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.excludedCategoryIds, other.excludedCategoryIds) && Objects.equals(this.excludedItemVariationIds, other.excludedItemVariationIds) && Objects.equals(this.taxMode, other.taxMode);
    }

    public String toString() {
        return "LoyaltyProgramAccrualRuleSpendData [amountMoney=" + this.amountMoney + ", taxMode=" + this.taxMode + ", excludedCategoryIds=" + this.excludedCategoryIds + ", excludedItemVariationIds=" + this.excludedItemVariationIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.amountMoney, this.taxMode);
        builder.excludedCategoryIds = this.internalGetExcludedCategoryIds();
        builder.excludedItemVariationIds = this.internalGetExcludedItemVariationIds();
        return builder;
    }

    public static class Builder {
        private Money amountMoney;
        private String taxMode;
        private OptionalNullable<List<String>> excludedCategoryIds;
        private OptionalNullable<List<String>> excludedItemVariationIds;

        public Builder(Money amountMoney, String taxMode) {
            this.amountMoney = amountMoney;
            this.taxMode = taxMode;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder taxMode(String taxMode) {
            this.taxMode = taxMode;
            return this;
        }

        public Builder excludedCategoryIds(List<String> excludedCategoryIds) {
            this.excludedCategoryIds = OptionalNullable.of(excludedCategoryIds);
            return this;
        }

        public Builder unsetExcludedCategoryIds() {
            this.excludedCategoryIds = null;
            return this;
        }

        public Builder excludedItemVariationIds(List<String> excludedItemVariationIds) {
            this.excludedItemVariationIds = OptionalNullable.of(excludedItemVariationIds);
            return this;
        }

        public Builder unsetExcludedItemVariationIds() {
            this.excludedItemVariationIds = null;
            return this;
        }

        public LoyaltyProgramAccrualRuleSpendData build() {
            return new LoyaltyProgramAccrualRuleSpendData(this.amountMoney, this.taxMode, this.excludedCategoryIds, this.excludedItemVariationIds);
        }
    }
}

