/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Money;
import java.util.Objects;

public class LoyaltyProgramAccrualRuleVisitData {
    private final Money minimumAmountMoney;
    private final String taxMode;

    @JsonCreator
    public LoyaltyProgramAccrualRuleVisitData(@JsonProperty(value="tax_mode") String taxMode, @JsonProperty(value="minimum_amount_money") Money minimumAmountMoney) {
        this.minimumAmountMoney = minimumAmountMoney;
        this.taxMode = taxMode;
    }

    @JsonGetter(value="minimum_amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getMinimumAmountMoney() {
        return this.minimumAmountMoney;
    }

    @JsonGetter(value="tax_mode")
    public String getTaxMode() {
        return this.taxMode;
    }

    public int hashCode() {
        return Objects.hash(this.minimumAmountMoney, this.taxMode);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyProgramAccrualRuleVisitData)) {
            return false;
        }
        LoyaltyProgramAccrualRuleVisitData other = (LoyaltyProgramAccrualRuleVisitData)obj;
        return Objects.equals(this.minimumAmountMoney, other.minimumAmountMoney) && Objects.equals(this.taxMode, other.taxMode);
    }

    public String toString() {
        return "LoyaltyProgramAccrualRuleVisitData [taxMode=" + this.taxMode + ", minimumAmountMoney=" + this.minimumAmountMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.taxMode).minimumAmountMoney(this.getMinimumAmountMoney());
        return builder;
    }

    public static class Builder {
        private String taxMode;
        private Money minimumAmountMoney;

        public Builder(String taxMode) {
            this.taxMode = taxMode;
        }

        public Builder taxMode(String taxMode) {
            this.taxMode = taxMode;
            return this;
        }

        public Builder minimumAmountMoney(Money minimumAmountMoney) {
            this.minimumAmountMoney = minimumAmountMoney;
            return this;
        }

        public LoyaltyProgramAccrualRuleVisitData build() {
            return new LoyaltyProgramAccrualRuleVisitData(this.taxMode, this.minimumAmountMoney);
        }
    }
}

