/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.LoyaltyPromotionAvailableTimeData;
import com.squareup.square.models.LoyaltyPromotionIncentive;
import com.squareup.square.models.LoyaltyPromotionTriggerLimit;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class LoyaltyPromotion {
    private final String id;
    private final String name;
    private final LoyaltyPromotionIncentive incentive;
    private final LoyaltyPromotionAvailableTimeData availableTime;
    private final LoyaltyPromotionTriggerLimit triggerLimit;
    private final String status;
    private final String createdAt;
    private final String canceledAt;
    private final String updatedAt;
    private final String loyaltyProgramId;
    private final Money minimumSpendAmountMoney;
    private final OptionalNullable<List<String>> qualifyingItemVariationIds;
    private final OptionalNullable<List<String>> qualifyingCategoryIds;

    @JsonCreator
    public LoyaltyPromotion(@JsonProperty(value="name") String name, @JsonProperty(value="incentive") LoyaltyPromotionIncentive incentive, @JsonProperty(value="available_time") LoyaltyPromotionAvailableTimeData availableTime, @JsonProperty(value="id") String id, @JsonProperty(value="trigger_limit") LoyaltyPromotionTriggerLimit triggerLimit, @JsonProperty(value="status") String status, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="canceled_at") String canceledAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="loyalty_program_id") String loyaltyProgramId, @JsonProperty(value="minimum_spend_amount_money") Money minimumSpendAmountMoney, @JsonProperty(value="qualifying_item_variation_ids") List<String> qualifyingItemVariationIds, @JsonProperty(value="qualifying_category_ids") List<String> qualifyingCategoryIds) {
        this.id = id;
        this.name = name;
        this.incentive = incentive;
        this.availableTime = availableTime;
        this.triggerLimit = triggerLimit;
        this.status = status;
        this.createdAt = createdAt;
        this.canceledAt = canceledAt;
        this.updatedAt = updatedAt;
        this.loyaltyProgramId = loyaltyProgramId;
        this.minimumSpendAmountMoney = minimumSpendAmountMoney;
        this.qualifyingItemVariationIds = OptionalNullable.of(qualifyingItemVariationIds);
        this.qualifyingCategoryIds = OptionalNullable.of(qualifyingCategoryIds);
    }

    protected LoyaltyPromotion(String name, LoyaltyPromotionIncentive incentive, LoyaltyPromotionAvailableTimeData availableTime, String id, LoyaltyPromotionTriggerLimit triggerLimit, String status, String createdAt, String canceledAt, String updatedAt, String loyaltyProgramId, Money minimumSpendAmountMoney, OptionalNullable<List<String>> qualifyingItemVariationIds, OptionalNullable<List<String>> qualifyingCategoryIds) {
        this.id = id;
        this.name = name;
        this.incentive = incentive;
        this.availableTime = availableTime;
        this.triggerLimit = triggerLimit;
        this.status = status;
        this.createdAt = createdAt;
        this.canceledAt = canceledAt;
        this.updatedAt = updatedAt;
        this.loyaltyProgramId = loyaltyProgramId;
        this.minimumSpendAmountMoney = minimumSpendAmountMoney;
        this.qualifyingItemVariationIds = qualifyingItemVariationIds;
        this.qualifyingCategoryIds = qualifyingCategoryIds;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="incentive")
    public LoyaltyPromotionIncentive getIncentive() {
        return this.incentive;
    }

    @JsonGetter(value="available_time")
    public LoyaltyPromotionAvailableTimeData getAvailableTime() {
        return this.availableTime;
    }

    @JsonGetter(value="trigger_limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public LoyaltyPromotionTriggerLimit getTriggerLimit() {
        return this.triggerLimit;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="canceled_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCanceledAt() {
        return this.canceledAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="loyalty_program_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLoyaltyProgramId() {
        return this.loyaltyProgramId;
    }

    @JsonGetter(value="minimum_spend_amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getMinimumSpendAmountMoney() {
        return this.minimumSpendAmountMoney;
    }

    @JsonGetter(value="qualifying_item_variation_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetQualifyingItemVariationIds() {
        return this.qualifyingItemVariationIds;
    }

    @JsonIgnore
    public List<String> getQualifyingItemVariationIds() {
        return (List)OptionalNullable.getFrom(this.qualifyingItemVariationIds);
    }

    @JsonGetter(value="qualifying_category_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetQualifyingCategoryIds() {
        return this.qualifyingCategoryIds;
    }

    @JsonIgnore
    public List<String> getQualifyingCategoryIds() {
        return (List)OptionalNullable.getFrom(this.qualifyingCategoryIds);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.incentive, this.availableTime, this.triggerLimit, this.status, this.createdAt, this.canceledAt, this.updatedAt, this.loyaltyProgramId, this.minimumSpendAmountMoney, this.qualifyingItemVariationIds, this.qualifyingCategoryIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyPromotion)) {
            return false;
        }
        LoyaltyPromotion other = (LoyaltyPromotion)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.incentive, other.incentive) && Objects.equals(this.availableTime, other.availableTime) && Objects.equals(this.triggerLimit, other.triggerLimit) && Objects.equals(this.status, other.status) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.canceledAt, other.canceledAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.loyaltyProgramId, other.loyaltyProgramId) && Objects.equals(this.minimumSpendAmountMoney, other.minimumSpendAmountMoney) && Objects.equals(this.qualifyingItemVariationIds, other.qualifyingItemVariationIds) && Objects.equals(this.qualifyingCategoryIds, other.qualifyingCategoryIds);
    }

    public String toString() {
        return "LoyaltyPromotion [name=" + this.name + ", incentive=" + this.incentive + ", availableTime=" + this.availableTime + ", id=" + this.id + ", triggerLimit=" + this.triggerLimit + ", status=" + this.status + ", createdAt=" + this.createdAt + ", canceledAt=" + this.canceledAt + ", updatedAt=" + this.updatedAt + ", loyaltyProgramId=" + this.loyaltyProgramId + ", minimumSpendAmountMoney=" + this.minimumSpendAmountMoney + ", qualifyingItemVariationIds=" + this.qualifyingItemVariationIds + ", qualifyingCategoryIds=" + this.qualifyingCategoryIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.name, this.incentive, this.availableTime).id(this.getId()).triggerLimit(this.getTriggerLimit()).status(this.getStatus()).createdAt(this.getCreatedAt()).canceledAt(this.getCanceledAt()).updatedAt(this.getUpdatedAt()).loyaltyProgramId(this.getLoyaltyProgramId()).minimumSpendAmountMoney(this.getMinimumSpendAmountMoney());
        builder.qualifyingItemVariationIds = this.internalGetQualifyingItemVariationIds();
        builder.qualifyingCategoryIds = this.internalGetQualifyingCategoryIds();
        return builder;
    }

    public static class Builder {
        private String name;
        private LoyaltyPromotionIncentive incentive;
        private LoyaltyPromotionAvailableTimeData availableTime;
        private String id;
        private LoyaltyPromotionTriggerLimit triggerLimit;
        private String status;
        private String createdAt;
        private String canceledAt;
        private String updatedAt;
        private String loyaltyProgramId;
        private Money minimumSpendAmountMoney;
        private OptionalNullable<List<String>> qualifyingItemVariationIds;
        private OptionalNullable<List<String>> qualifyingCategoryIds;

        public Builder(String name, LoyaltyPromotionIncentive incentive, LoyaltyPromotionAvailableTimeData availableTime) {
            this.name = name;
            this.incentive = incentive;
            this.availableTime = availableTime;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder incentive(LoyaltyPromotionIncentive incentive) {
            this.incentive = incentive;
            return this;
        }

        public Builder availableTime(LoyaltyPromotionAvailableTimeData availableTime) {
            this.availableTime = availableTime;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder triggerLimit(LoyaltyPromotionTriggerLimit triggerLimit) {
            this.triggerLimit = triggerLimit;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder canceledAt(String canceledAt) {
            this.canceledAt = canceledAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder loyaltyProgramId(String loyaltyProgramId) {
            this.loyaltyProgramId = loyaltyProgramId;
            return this;
        }

        public Builder minimumSpendAmountMoney(Money minimumSpendAmountMoney) {
            this.minimumSpendAmountMoney = minimumSpendAmountMoney;
            return this;
        }

        public Builder qualifyingItemVariationIds(List<String> qualifyingItemVariationIds) {
            this.qualifyingItemVariationIds = OptionalNullable.of(qualifyingItemVariationIds);
            return this;
        }

        public Builder unsetQualifyingItemVariationIds() {
            this.qualifyingItemVariationIds = null;
            return this;
        }

        public Builder qualifyingCategoryIds(List<String> qualifyingCategoryIds) {
            this.qualifyingCategoryIds = OptionalNullable.of(qualifyingCategoryIds);
            return this;
        }

        public Builder unsetQualifyingCategoryIds() {
            this.qualifyingCategoryIds = null;
            return this;
        }

        public LoyaltyPromotion build() {
            return new LoyaltyPromotion(this.name, this.incentive, this.availableTime, this.id, this.triggerLimit, this.status, this.createdAt, this.canceledAt, this.updatedAt, this.loyaltyProgramId, this.minimumSpendAmountMoney, this.qualifyingItemVariationIds, this.qualifyingCategoryIds);
        }
    }
}

