/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class LoyaltyReward {
    private final String id;
    private final String status;
    private final String loyaltyAccountId;
    private final String rewardTierId;
    private final Integer points;
    private final OptionalNullable<String> orderId;
    private final String createdAt;
    private final String updatedAt;
    private final String redeemedAt;

    @JsonCreator
    public LoyaltyReward(@JsonProperty(value="loyalty_account_id") String loyaltyAccountId, @JsonProperty(value="reward_tier_id") String rewardTierId, @JsonProperty(value="id") String id, @JsonProperty(value="status") String status, @JsonProperty(value="points") Integer points, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="redeemed_at") String redeemedAt) {
        this.id = id;
        this.status = status;
        this.loyaltyAccountId = loyaltyAccountId;
        this.rewardTierId = rewardTierId;
        this.points = points;
        this.orderId = OptionalNullable.of((Object)orderId);
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.redeemedAt = redeemedAt;
    }

    protected LoyaltyReward(String loyaltyAccountId, String rewardTierId, String id, String status, Integer points, OptionalNullable<String> orderId, String createdAt, String updatedAt, String redeemedAt) {
        this.id = id;
        this.status = status;
        this.loyaltyAccountId = loyaltyAccountId;
        this.rewardTierId = rewardTierId;
        this.points = points;
        this.orderId = orderId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.redeemedAt = redeemedAt;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="loyalty_account_id")
    public String getLoyaltyAccountId() {
        return this.loyaltyAccountId;
    }

    @JsonGetter(value="reward_tier_id")
    public String getRewardTierId() {
        return this.rewardTierId;
    }

    @JsonGetter(value="points")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getPoints() {
        return this.points;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetOrderId() {
        return this.orderId;
    }

    @JsonIgnore
    public String getOrderId() {
        return (String)OptionalNullable.getFrom(this.orderId);
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="redeemed_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRedeemedAt() {
        return this.redeemedAt;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.loyaltyAccountId, this.rewardTierId, this.points, this.orderId, this.createdAt, this.updatedAt, this.redeemedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoyaltyReward)) {
            return false;
        }
        LoyaltyReward other = (LoyaltyReward)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.status, other.status) && Objects.equals(this.loyaltyAccountId, other.loyaltyAccountId) && Objects.equals(this.rewardTierId, other.rewardTierId) && Objects.equals(this.points, other.points) && Objects.equals(this.orderId, other.orderId) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.redeemedAt, other.redeemedAt);
    }

    public String toString() {
        return "LoyaltyReward [loyaltyAccountId=" + this.loyaltyAccountId + ", rewardTierId=" + this.rewardTierId + ", id=" + this.id + ", status=" + this.status + ", points=" + this.points + ", orderId=" + this.orderId + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", redeemedAt=" + this.redeemedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.loyaltyAccountId, this.rewardTierId).id(this.getId()).status(this.getStatus()).points(this.getPoints()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).redeemedAt(this.getRedeemedAt());
        builder.orderId = this.internalGetOrderId();
        return builder;
    }

    public static class Builder {
        private String loyaltyAccountId;
        private String rewardTierId;
        private String id;
        private String status;
        private Integer points;
        private OptionalNullable<String> orderId;
        private String createdAt;
        private String updatedAt;
        private String redeemedAt;

        public Builder(String loyaltyAccountId, String rewardTierId) {
            this.loyaltyAccountId = loyaltyAccountId;
            this.rewardTierId = rewardTierId;
        }

        public Builder loyaltyAccountId(String loyaltyAccountId) {
            this.loyaltyAccountId = loyaltyAccountId;
            return this;
        }

        public Builder rewardTierId(String rewardTierId) {
            this.rewardTierId = rewardTierId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder points(Integer points) {
            this.points = points;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = OptionalNullable.of((Object)orderId);
            return this;
        }

        public Builder unsetOrderId() {
            this.orderId = null;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder redeemedAt(String redeemedAt) {
            this.redeemedAt = redeemedAt;
            return this;
        }

        public LoyaltyReward build() {
            return new LoyaltyReward(this.loyaltyAccountId, this.rewardTierId, this.id, this.status, this.points, this.orderId, this.createdAt, this.updatedAt, this.redeemedAt);
        }
    }
}

