/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Fulfillment;
import com.squareup.square.models.Money;
import com.squareup.square.models.OrderLineItem;
import com.squareup.square.models.OrderLineItemDiscount;
import com.squareup.square.models.OrderLineItemTax;
import com.squareup.square.models.OrderMoneyAmounts;
import com.squareup.square.models.OrderPricingOptions;
import com.squareup.square.models.OrderReturn;
import com.squareup.square.models.OrderReward;
import com.squareup.square.models.OrderRoundingAdjustment;
import com.squareup.square.models.OrderServiceCharge;
import com.squareup.square.models.OrderSource;
import com.squareup.square.models.Refund;
import com.squareup.square.models.Tender;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Order {
    private final String id;
    private final String locationId;
    private final OptionalNullable<String> referenceId;
    private final OrderSource source;
    private final OptionalNullable<String> customerId;
    private final OptionalNullable<List<OrderLineItem>> lineItems;
    private final OptionalNullable<List<OrderLineItemTax>> taxes;
    private final OptionalNullable<List<OrderLineItemDiscount>> discounts;
    private final OptionalNullable<List<OrderServiceCharge>> serviceCharges;
    private final OptionalNullable<List<Fulfillment>> fulfillments;
    private final List<OrderReturn> returns;
    private final OrderMoneyAmounts returnAmounts;
    private final OrderMoneyAmounts netAmounts;
    private final OrderRoundingAdjustment roundingAdjustment;
    private final List<Tender> tenders;
    private final List<Refund> refunds;
    private final OptionalNullable<Map<String, String>> metadata;
    private final String createdAt;
    private final String updatedAt;
    private final String closedAt;
    private final String state;
    private final Integer version;
    private final Money totalMoney;
    private final Money totalTaxMoney;
    private final Money totalDiscountMoney;
    private final Money totalTipMoney;
    private final Money totalServiceChargeMoney;
    private final OptionalNullable<String> ticketName;
    private final OrderPricingOptions pricingOptions;
    private final List<OrderReward> rewards;
    private final Money netAmountDueMoney;

    @JsonCreator
    public Order(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="id") String id, @JsonProperty(value="reference_id") String referenceId, @JsonProperty(value="source") OrderSource source, @JsonProperty(value="customer_id") String customerId, @JsonProperty(value="line_items") List<OrderLineItem> lineItems, @JsonProperty(value="taxes") List<OrderLineItemTax> taxes, @JsonProperty(value="discounts") List<OrderLineItemDiscount> discounts, @JsonProperty(value="service_charges") List<OrderServiceCharge> serviceCharges, @JsonProperty(value="fulfillments") List<Fulfillment> fulfillments, @JsonProperty(value="returns") List<OrderReturn> returns, @JsonProperty(value="return_amounts") OrderMoneyAmounts returnAmounts, @JsonProperty(value="net_amounts") OrderMoneyAmounts netAmounts, @JsonProperty(value="rounding_adjustment") OrderRoundingAdjustment roundingAdjustment, @JsonProperty(value="tenders") List<Tender> tenders, @JsonProperty(value="refunds") List<Refund> refunds, @JsonProperty(value="metadata") Map<String, String> metadata, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="closed_at") String closedAt, @JsonProperty(value="state") String state, @JsonProperty(value="version") Integer version, @JsonProperty(value="total_money") Money totalMoney, @JsonProperty(value="total_tax_money") Money totalTaxMoney, @JsonProperty(value="total_discount_money") Money totalDiscountMoney, @JsonProperty(value="total_tip_money") Money totalTipMoney, @JsonProperty(value="total_service_charge_money") Money totalServiceChargeMoney, @JsonProperty(value="ticket_name") String ticketName, @JsonProperty(value="pricing_options") OrderPricingOptions pricingOptions, @JsonProperty(value="rewards") List<OrderReward> rewards, @JsonProperty(value="net_amount_due_money") Money netAmountDueMoney) {
        this.id = id;
        this.locationId = locationId;
        this.referenceId = OptionalNullable.of((Object)referenceId);
        this.source = source;
        this.customerId = OptionalNullable.of((Object)customerId);
        this.lineItems = OptionalNullable.of(lineItems);
        this.taxes = OptionalNullable.of(taxes);
        this.discounts = OptionalNullable.of(discounts);
        this.serviceCharges = OptionalNullable.of(serviceCharges);
        this.fulfillments = OptionalNullable.of(fulfillments);
        this.returns = returns;
        this.returnAmounts = returnAmounts;
        this.netAmounts = netAmounts;
        this.roundingAdjustment = roundingAdjustment;
        this.tenders = tenders;
        this.refunds = refunds;
        this.metadata = OptionalNullable.of(metadata);
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.closedAt = closedAt;
        this.state = state;
        this.version = version;
        this.totalMoney = totalMoney;
        this.totalTaxMoney = totalTaxMoney;
        this.totalDiscountMoney = totalDiscountMoney;
        this.totalTipMoney = totalTipMoney;
        this.totalServiceChargeMoney = totalServiceChargeMoney;
        this.ticketName = OptionalNullable.of((Object)ticketName);
        this.pricingOptions = pricingOptions;
        this.rewards = rewards;
        this.netAmountDueMoney = netAmountDueMoney;
    }

    protected Order(String locationId, String id, OptionalNullable<String> referenceId, OrderSource source, OptionalNullable<String> customerId, OptionalNullable<List<OrderLineItem>> lineItems, OptionalNullable<List<OrderLineItemTax>> taxes, OptionalNullable<List<OrderLineItemDiscount>> discounts, OptionalNullable<List<OrderServiceCharge>> serviceCharges, OptionalNullable<List<Fulfillment>> fulfillments, List<OrderReturn> returns, OrderMoneyAmounts returnAmounts, OrderMoneyAmounts netAmounts, OrderRoundingAdjustment roundingAdjustment, List<Tender> tenders, List<Refund> refunds, OptionalNullable<Map<String, String>> metadata, String createdAt, String updatedAt, String closedAt, String state, Integer version, Money totalMoney, Money totalTaxMoney, Money totalDiscountMoney, Money totalTipMoney, Money totalServiceChargeMoney, OptionalNullable<String> ticketName, OrderPricingOptions pricingOptions, List<OrderReward> rewards, Money netAmountDueMoney) {
        this.id = id;
        this.locationId = locationId;
        this.referenceId = referenceId;
        this.source = source;
        this.customerId = customerId;
        this.lineItems = lineItems;
        this.taxes = taxes;
        this.discounts = discounts;
        this.serviceCharges = serviceCharges;
        this.fulfillments = fulfillments;
        this.returns = returns;
        this.returnAmounts = returnAmounts;
        this.netAmounts = netAmounts;
        this.roundingAdjustment = roundingAdjustment;
        this.tenders = tenders;
        this.refunds = refunds;
        this.metadata = metadata;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.closedAt = closedAt;
        this.state = state;
        this.version = version;
        this.totalMoney = totalMoney;
        this.totalTaxMoney = totalTaxMoney;
        this.totalDiscountMoney = totalDiscountMoney;
        this.totalTipMoney = totalTipMoney;
        this.totalServiceChargeMoney = totalServiceChargeMoney;
        this.ticketName = ticketName;
        this.pricingOptions = pricingOptions;
        this.rewards = rewards;
        this.netAmountDueMoney = netAmountDueMoney;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="reference_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetReferenceId() {
        return this.referenceId;
    }

    @JsonIgnore
    public String getReferenceId() {
        return (String)OptionalNullable.getFrom(this.referenceId);
    }

    @JsonGetter(value="source")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderSource getSource() {
        return this.source;
    }

    @JsonGetter(value="customer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCustomerId() {
        return this.customerId;
    }

    @JsonIgnore
    public String getCustomerId() {
        return (String)OptionalNullable.getFrom(this.customerId);
    }

    @JsonGetter(value="line_items")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderLineItem>> internalGetLineItems() {
        return this.lineItems;
    }

    @JsonIgnore
    public List<OrderLineItem> getLineItems() {
        return (List)OptionalNullable.getFrom(this.lineItems);
    }

    @JsonGetter(value="taxes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderLineItemTax>> internalGetTaxes() {
        return this.taxes;
    }

    @JsonIgnore
    public List<OrderLineItemTax> getTaxes() {
        return (List)OptionalNullable.getFrom(this.taxes);
    }

    @JsonGetter(value="discounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderLineItemDiscount>> internalGetDiscounts() {
        return this.discounts;
    }

    @JsonIgnore
    public List<OrderLineItemDiscount> getDiscounts() {
        return (List)OptionalNullable.getFrom(this.discounts);
    }

    @JsonGetter(value="service_charges")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderServiceCharge>> internalGetServiceCharges() {
        return this.serviceCharges;
    }

    @JsonIgnore
    public List<OrderServiceCharge> getServiceCharges() {
        return (List)OptionalNullable.getFrom(this.serviceCharges);
    }

    @JsonGetter(value="fulfillments")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<Fulfillment>> internalGetFulfillments() {
        return this.fulfillments;
    }

    @JsonIgnore
    public List<Fulfillment> getFulfillments() {
        return (List)OptionalNullable.getFrom(this.fulfillments);
    }

    @JsonGetter(value="returns")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderReturn> getReturns() {
        return this.returns;
    }

    @JsonGetter(value="return_amounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderMoneyAmounts getReturnAmounts() {
        return this.returnAmounts;
    }

    @JsonGetter(value="net_amounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderMoneyAmounts getNetAmounts() {
        return this.netAmounts;
    }

    @JsonGetter(value="rounding_adjustment")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderRoundingAdjustment getRoundingAdjustment() {
        return this.roundingAdjustment;
    }

    @JsonGetter(value="tenders")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Tender> getTenders() {
        return this.tenders;
    }

    @JsonGetter(value="refunds")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Refund> getRefunds() {
        return this.refunds;
    }

    @JsonGetter(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Map<String, String>> internalGetMetadata() {
        return this.metadata;
    }

    @JsonIgnore
    public Map<String, String> getMetadata() {
        return (Map)OptionalNullable.getFrom(this.metadata);
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="closed_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getClosedAt() {
        return this.closedAt;
    }

    @JsonGetter(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getState() {
        return this.state;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="total_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalMoney() {
        return this.totalMoney;
    }

    @JsonGetter(value="total_tax_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalTaxMoney() {
        return this.totalTaxMoney;
    }

    @JsonGetter(value="total_discount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalDiscountMoney() {
        return this.totalDiscountMoney;
    }

    @JsonGetter(value="total_tip_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalTipMoney() {
        return this.totalTipMoney;
    }

    @JsonGetter(value="total_service_charge_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalServiceChargeMoney() {
        return this.totalServiceChargeMoney;
    }

    @JsonGetter(value="ticket_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTicketName() {
        return this.ticketName;
    }

    @JsonIgnore
    public String getTicketName() {
        return (String)OptionalNullable.getFrom(this.ticketName);
    }

    @JsonGetter(value="pricing_options")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderPricingOptions getPricingOptions() {
        return this.pricingOptions;
    }

    @JsonGetter(value="rewards")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderReward> getRewards() {
        return this.rewards;
    }

    @JsonGetter(value="net_amount_due_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getNetAmountDueMoney() {
        return this.netAmountDueMoney;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.locationId, this.referenceId, this.source, this.customerId, this.lineItems, this.taxes, this.discounts, this.serviceCharges, this.fulfillments, this.returns, this.returnAmounts, this.netAmounts, this.roundingAdjustment, this.tenders, this.refunds, this.metadata, this.createdAt, this.updatedAt, this.closedAt, this.state, this.version, this.totalMoney, this.totalTaxMoney, this.totalDiscountMoney, this.totalTipMoney, this.totalServiceChargeMoney, this.ticketName, this.pricingOptions, this.rewards, this.netAmountDueMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Order)) {
            return false;
        }
        Order other = (Order)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.referenceId, other.referenceId) && Objects.equals(this.source, other.source) && Objects.equals(this.customerId, other.customerId) && Objects.equals(this.lineItems, other.lineItems) && Objects.equals(this.taxes, other.taxes) && Objects.equals(this.discounts, other.discounts) && Objects.equals(this.serviceCharges, other.serviceCharges) && Objects.equals(this.fulfillments, other.fulfillments) && Objects.equals(this.returns, other.returns) && Objects.equals(this.returnAmounts, other.returnAmounts) && Objects.equals(this.netAmounts, other.netAmounts) && Objects.equals(this.roundingAdjustment, other.roundingAdjustment) && Objects.equals(this.tenders, other.tenders) && Objects.equals(this.refunds, other.refunds) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.closedAt, other.closedAt) && Objects.equals(this.state, other.state) && Objects.equals(this.version, other.version) && Objects.equals(this.totalMoney, other.totalMoney) && Objects.equals(this.totalTaxMoney, other.totalTaxMoney) && Objects.equals(this.totalDiscountMoney, other.totalDiscountMoney) && Objects.equals(this.totalTipMoney, other.totalTipMoney) && Objects.equals(this.totalServiceChargeMoney, other.totalServiceChargeMoney) && Objects.equals(this.ticketName, other.ticketName) && Objects.equals(this.pricingOptions, other.pricingOptions) && Objects.equals(this.rewards, other.rewards) && Objects.equals(this.netAmountDueMoney, other.netAmountDueMoney);
    }

    public String toString() {
        return "Order [locationId=" + this.locationId + ", id=" + this.id + ", referenceId=" + this.referenceId + ", source=" + this.source + ", customerId=" + this.customerId + ", lineItems=" + this.lineItems + ", taxes=" + this.taxes + ", discounts=" + this.discounts + ", serviceCharges=" + this.serviceCharges + ", fulfillments=" + this.fulfillments + ", returns=" + this.returns + ", returnAmounts=" + this.returnAmounts + ", netAmounts=" + this.netAmounts + ", roundingAdjustment=" + this.roundingAdjustment + ", tenders=" + this.tenders + ", refunds=" + this.refunds + ", metadata=" + this.metadata + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", closedAt=" + this.closedAt + ", state=" + this.state + ", version=" + this.version + ", totalMoney=" + this.totalMoney + ", totalTaxMoney=" + this.totalTaxMoney + ", totalDiscountMoney=" + this.totalDiscountMoney + ", totalTipMoney=" + this.totalTipMoney + ", totalServiceChargeMoney=" + this.totalServiceChargeMoney + ", ticketName=" + this.ticketName + ", pricingOptions=" + this.pricingOptions + ", rewards=" + this.rewards + ", netAmountDueMoney=" + this.netAmountDueMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.locationId).id(this.getId()).source(this.getSource()).returns(this.getReturns()).returnAmounts(this.getReturnAmounts()).netAmounts(this.getNetAmounts()).roundingAdjustment(this.getRoundingAdjustment()).tenders(this.getTenders()).refunds(this.getRefunds()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).closedAt(this.getClosedAt()).state(this.getState()).version(this.getVersion()).totalMoney(this.getTotalMoney()).totalTaxMoney(this.getTotalTaxMoney()).totalDiscountMoney(this.getTotalDiscountMoney()).totalTipMoney(this.getTotalTipMoney()).totalServiceChargeMoney(this.getTotalServiceChargeMoney()).pricingOptions(this.getPricingOptions()).rewards(this.getRewards()).netAmountDueMoney(this.getNetAmountDueMoney());
        builder.referenceId = this.internalGetReferenceId();
        builder.customerId = this.internalGetCustomerId();
        builder.lineItems = this.internalGetLineItems();
        builder.taxes = this.internalGetTaxes();
        builder.discounts = this.internalGetDiscounts();
        builder.serviceCharges = this.internalGetServiceCharges();
        builder.fulfillments = this.internalGetFulfillments();
        builder.metadata = this.internalGetMetadata();
        builder.ticketName = this.internalGetTicketName();
        return builder;
    }

    public static class Builder {
        private String locationId;
        private String id;
        private OptionalNullable<String> referenceId;
        private OrderSource source;
        private OptionalNullable<String> customerId;
        private OptionalNullable<List<OrderLineItem>> lineItems;
        private OptionalNullable<List<OrderLineItemTax>> taxes;
        private OptionalNullable<List<OrderLineItemDiscount>> discounts;
        private OptionalNullable<List<OrderServiceCharge>> serviceCharges;
        private OptionalNullable<List<Fulfillment>> fulfillments;
        private List<OrderReturn> returns;
        private OrderMoneyAmounts returnAmounts;
        private OrderMoneyAmounts netAmounts;
        private OrderRoundingAdjustment roundingAdjustment;
        private List<Tender> tenders;
        private List<Refund> refunds;
        private OptionalNullable<Map<String, String>> metadata;
        private String createdAt;
        private String updatedAt;
        private String closedAt;
        private String state;
        private Integer version;
        private Money totalMoney;
        private Money totalTaxMoney;
        private Money totalDiscountMoney;
        private Money totalTipMoney;
        private Money totalServiceChargeMoney;
        private OptionalNullable<String> ticketName;
        private OrderPricingOptions pricingOptions;
        private List<OrderReward> rewards;
        private Money netAmountDueMoney;

        public Builder(String locationId) {
            this.locationId = locationId;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder referenceId(String referenceId) {
            this.referenceId = OptionalNullable.of((Object)referenceId);
            return this;
        }

        public Builder unsetReferenceId() {
            this.referenceId = null;
            return this;
        }

        public Builder source(OrderSource source) {
            this.source = source;
            return this;
        }

        public Builder customerId(String customerId) {
            this.customerId = OptionalNullable.of((Object)customerId);
            return this;
        }

        public Builder unsetCustomerId() {
            this.customerId = null;
            return this;
        }

        public Builder lineItems(List<OrderLineItem> lineItems) {
            this.lineItems = OptionalNullable.of(lineItems);
            return this;
        }

        public Builder unsetLineItems() {
            this.lineItems = null;
            return this;
        }

        public Builder taxes(List<OrderLineItemTax> taxes) {
            this.taxes = OptionalNullable.of(taxes);
            return this;
        }

        public Builder unsetTaxes() {
            this.taxes = null;
            return this;
        }

        public Builder discounts(List<OrderLineItemDiscount> discounts) {
            this.discounts = OptionalNullable.of(discounts);
            return this;
        }

        public Builder unsetDiscounts() {
            this.discounts = null;
            return this;
        }

        public Builder serviceCharges(List<OrderServiceCharge> serviceCharges) {
            this.serviceCharges = OptionalNullable.of(serviceCharges);
            return this;
        }

        public Builder unsetServiceCharges() {
            this.serviceCharges = null;
            return this;
        }

        public Builder fulfillments(List<Fulfillment> fulfillments) {
            this.fulfillments = OptionalNullable.of(fulfillments);
            return this;
        }

        public Builder unsetFulfillments() {
            this.fulfillments = null;
            return this;
        }

        public Builder returns(List<OrderReturn> returns) {
            this.returns = returns;
            return this;
        }

        public Builder returnAmounts(OrderMoneyAmounts returnAmounts) {
            this.returnAmounts = returnAmounts;
            return this;
        }

        public Builder netAmounts(OrderMoneyAmounts netAmounts) {
            this.netAmounts = netAmounts;
            return this;
        }

        public Builder roundingAdjustment(OrderRoundingAdjustment roundingAdjustment) {
            this.roundingAdjustment = roundingAdjustment;
            return this;
        }

        public Builder tenders(List<Tender> tenders) {
            this.tenders = tenders;
            return this;
        }

        public Builder refunds(List<Refund> refunds) {
            this.refunds = refunds;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = OptionalNullable.of(metadata);
            return this;
        }

        public Builder unsetMetadata() {
            this.metadata = null;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder closedAt(String closedAt) {
            this.closedAt = closedAt;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder totalMoney(Money totalMoney) {
            this.totalMoney = totalMoney;
            return this;
        }

        public Builder totalTaxMoney(Money totalTaxMoney) {
            this.totalTaxMoney = totalTaxMoney;
            return this;
        }

        public Builder totalDiscountMoney(Money totalDiscountMoney) {
            this.totalDiscountMoney = totalDiscountMoney;
            return this;
        }

        public Builder totalTipMoney(Money totalTipMoney) {
            this.totalTipMoney = totalTipMoney;
            return this;
        }

        public Builder totalServiceChargeMoney(Money totalServiceChargeMoney) {
            this.totalServiceChargeMoney = totalServiceChargeMoney;
            return this;
        }

        public Builder ticketName(String ticketName) {
            this.ticketName = OptionalNullable.of((Object)ticketName);
            return this;
        }

        public Builder unsetTicketName() {
            this.ticketName = null;
            return this;
        }

        public Builder pricingOptions(OrderPricingOptions pricingOptions) {
            this.pricingOptions = pricingOptions;
            return this;
        }

        public Builder rewards(List<OrderReward> rewards) {
            this.rewards = rewards;
            return this;
        }

        public Builder netAmountDueMoney(Money netAmountDueMoney) {
            this.netAmountDueMoney = netAmountDueMoney;
            return this;
        }

        public Order build() {
            return new Order(this.locationId, this.id, this.referenceId, this.source, this.customerId, this.lineItems, this.taxes, this.discounts, this.serviceCharges, this.fulfillments, this.returns, this.returnAmounts, this.netAmounts, this.roundingAdjustment, this.tenders, this.refunds, this.metadata, this.createdAt, this.updatedAt, this.closedAt, this.state, this.version, this.totalMoney, this.totalTaxMoney, this.totalDiscountMoney, this.totalTipMoney, this.totalServiceChargeMoney, this.ticketName, this.pricingOptions, this.rewards, this.netAmountDueMoney);
        }
    }
}

