/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.OrderFulfillmentPickupDetailsCurbsidePickupDetails;
import com.squareup.square.models.OrderFulfillmentRecipient;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class OrderFulfillmentPickupDetails {
    private final OrderFulfillmentRecipient recipient;
    private final OptionalNullable<String> expiresAt;
    private final OptionalNullable<String> autoCompleteDuration;
    private final String scheduleType;
    private final OptionalNullable<String> pickupAt;
    private final OptionalNullable<String> pickupWindowDuration;
    private final OptionalNullable<String> prepTimeDuration;
    private final OptionalNullable<String> note;
    private final String placedAt;
    private final String acceptedAt;
    private final String rejectedAt;
    private final String readyAt;
    private final String expiredAt;
    private final String pickedUpAt;
    private final String canceledAt;
    private final OptionalNullable<String> cancelReason;
    private final OptionalNullable<Boolean> isCurbsidePickup;
    private final OrderFulfillmentPickupDetailsCurbsidePickupDetails curbsidePickupDetails;

    @JsonCreator
    public OrderFulfillmentPickupDetails(@JsonProperty(value="recipient") OrderFulfillmentRecipient recipient, @JsonProperty(value="expires_at") String expiresAt, @JsonProperty(value="auto_complete_duration") String autoCompleteDuration, @JsonProperty(value="schedule_type") String scheduleType, @JsonProperty(value="pickup_at") String pickupAt, @JsonProperty(value="pickup_window_duration") String pickupWindowDuration, @JsonProperty(value="prep_time_duration") String prepTimeDuration, @JsonProperty(value="note") String note, @JsonProperty(value="placed_at") String placedAt, @JsonProperty(value="accepted_at") String acceptedAt, @JsonProperty(value="rejected_at") String rejectedAt, @JsonProperty(value="ready_at") String readyAt, @JsonProperty(value="expired_at") String expiredAt, @JsonProperty(value="picked_up_at") String pickedUpAt, @JsonProperty(value="canceled_at") String canceledAt, @JsonProperty(value="cancel_reason") String cancelReason, @JsonProperty(value="is_curbside_pickup") Boolean isCurbsidePickup, @JsonProperty(value="curbside_pickup_details") OrderFulfillmentPickupDetailsCurbsidePickupDetails curbsidePickupDetails) {
        this.recipient = recipient;
        this.expiresAt = OptionalNullable.of((Object)expiresAt);
        this.autoCompleteDuration = OptionalNullable.of((Object)autoCompleteDuration);
        this.scheduleType = scheduleType;
        this.pickupAt = OptionalNullable.of((Object)pickupAt);
        this.pickupWindowDuration = OptionalNullable.of((Object)pickupWindowDuration);
        this.prepTimeDuration = OptionalNullable.of((Object)prepTimeDuration);
        this.note = OptionalNullable.of((Object)note);
        this.placedAt = placedAt;
        this.acceptedAt = acceptedAt;
        this.rejectedAt = rejectedAt;
        this.readyAt = readyAt;
        this.expiredAt = expiredAt;
        this.pickedUpAt = pickedUpAt;
        this.canceledAt = canceledAt;
        this.cancelReason = OptionalNullable.of((Object)cancelReason);
        this.isCurbsidePickup = OptionalNullable.of((Object)isCurbsidePickup);
        this.curbsidePickupDetails = curbsidePickupDetails;
    }

    protected OrderFulfillmentPickupDetails(OrderFulfillmentRecipient recipient, OptionalNullable<String> expiresAt, OptionalNullable<String> autoCompleteDuration, String scheduleType, OptionalNullable<String> pickupAt, OptionalNullable<String> pickupWindowDuration, OptionalNullable<String> prepTimeDuration, OptionalNullable<String> note, String placedAt, String acceptedAt, String rejectedAt, String readyAt, String expiredAt, String pickedUpAt, String canceledAt, OptionalNullable<String> cancelReason, OptionalNullable<Boolean> isCurbsidePickup, OrderFulfillmentPickupDetailsCurbsidePickupDetails curbsidePickupDetails) {
        this.recipient = recipient;
        this.expiresAt = expiresAt;
        this.autoCompleteDuration = autoCompleteDuration;
        this.scheduleType = scheduleType;
        this.pickupAt = pickupAt;
        this.pickupWindowDuration = pickupWindowDuration;
        this.prepTimeDuration = prepTimeDuration;
        this.note = note;
        this.placedAt = placedAt;
        this.acceptedAt = acceptedAt;
        this.rejectedAt = rejectedAt;
        this.readyAt = readyAt;
        this.expiredAt = expiredAt;
        this.pickedUpAt = pickedUpAt;
        this.canceledAt = canceledAt;
        this.cancelReason = cancelReason;
        this.isCurbsidePickup = isCurbsidePickup;
        this.curbsidePickupDetails = curbsidePickupDetails;
    }

    @JsonGetter(value="recipient")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderFulfillmentRecipient getRecipient() {
        return this.recipient;
    }

    @JsonGetter(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetExpiresAt() {
        return this.expiresAt;
    }

    @JsonIgnore
    public String getExpiresAt() {
        return (String)OptionalNullable.getFrom(this.expiresAt);
    }

    @JsonGetter(value="auto_complete_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetAutoCompleteDuration() {
        return this.autoCompleteDuration;
    }

    @JsonIgnore
    public String getAutoCompleteDuration() {
        return (String)OptionalNullable.getFrom(this.autoCompleteDuration);
    }

    @JsonGetter(value="schedule_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getScheduleType() {
        return this.scheduleType;
    }

    @JsonGetter(value="pickup_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPickupAt() {
        return this.pickupAt;
    }

    @JsonIgnore
    public String getPickupAt() {
        return (String)OptionalNullable.getFrom(this.pickupAt);
    }

    @JsonGetter(value="pickup_window_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPickupWindowDuration() {
        return this.pickupWindowDuration;
    }

    @JsonIgnore
    public String getPickupWindowDuration() {
        return (String)OptionalNullable.getFrom(this.pickupWindowDuration);
    }

    @JsonGetter(value="prep_time_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPrepTimeDuration() {
        return this.prepTimeDuration;
    }

    @JsonIgnore
    public String getPrepTimeDuration() {
        return (String)OptionalNullable.getFrom(this.prepTimeDuration);
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetNote() {
        return this.note;
    }

    @JsonIgnore
    public String getNote() {
        return (String)OptionalNullable.getFrom(this.note);
    }

    @JsonGetter(value="placed_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPlacedAt() {
        return this.placedAt;
    }

    @JsonGetter(value="accepted_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAcceptedAt() {
        return this.acceptedAt;
    }

    @JsonGetter(value="rejected_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRejectedAt() {
        return this.rejectedAt;
    }

    @JsonGetter(value="ready_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReadyAt() {
        return this.readyAt;
    }

    @JsonGetter(value="expired_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getExpiredAt() {
        return this.expiredAt;
    }

    @JsonGetter(value="picked_up_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPickedUpAt() {
        return this.pickedUpAt;
    }

    @JsonGetter(value="canceled_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCanceledAt() {
        return this.canceledAt;
    }

    @JsonGetter(value="cancel_reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCancelReason() {
        return this.cancelReason;
    }

    @JsonIgnore
    public String getCancelReason() {
        return (String)OptionalNullable.getFrom(this.cancelReason);
    }

    @JsonGetter(value="is_curbside_pickup")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetIsCurbsidePickup() {
        return this.isCurbsidePickup;
    }

    @JsonIgnore
    public Boolean getIsCurbsidePickup() {
        return (Boolean)OptionalNullable.getFrom(this.isCurbsidePickup);
    }

    @JsonGetter(value="curbside_pickup_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderFulfillmentPickupDetailsCurbsidePickupDetails getCurbsidePickupDetails() {
        return this.curbsidePickupDetails;
    }

    public int hashCode() {
        return Objects.hash(this.recipient, this.expiresAt, this.autoCompleteDuration, this.scheduleType, this.pickupAt, this.pickupWindowDuration, this.prepTimeDuration, this.note, this.placedAt, this.acceptedAt, this.rejectedAt, this.readyAt, this.expiredAt, this.pickedUpAt, this.canceledAt, this.cancelReason, this.isCurbsidePickup, this.curbsidePickupDetails);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderFulfillmentPickupDetails)) {
            return false;
        }
        OrderFulfillmentPickupDetails other = (OrderFulfillmentPickupDetails)obj;
        return Objects.equals(this.recipient, other.recipient) && Objects.equals(this.expiresAt, other.expiresAt) && Objects.equals(this.autoCompleteDuration, other.autoCompleteDuration) && Objects.equals(this.scheduleType, other.scheduleType) && Objects.equals(this.pickupAt, other.pickupAt) && Objects.equals(this.pickupWindowDuration, other.pickupWindowDuration) && Objects.equals(this.prepTimeDuration, other.prepTimeDuration) && Objects.equals(this.note, other.note) && Objects.equals(this.placedAt, other.placedAt) && Objects.equals(this.acceptedAt, other.acceptedAt) && Objects.equals(this.rejectedAt, other.rejectedAt) && Objects.equals(this.readyAt, other.readyAt) && Objects.equals(this.expiredAt, other.expiredAt) && Objects.equals(this.pickedUpAt, other.pickedUpAt) && Objects.equals(this.canceledAt, other.canceledAt) && Objects.equals(this.cancelReason, other.cancelReason) && Objects.equals(this.isCurbsidePickup, other.isCurbsidePickup) && Objects.equals(this.curbsidePickupDetails, other.curbsidePickupDetails);
    }

    public String toString() {
        return "OrderFulfillmentPickupDetails [recipient=" + this.recipient + ", expiresAt=" + this.expiresAt + ", autoCompleteDuration=" + this.autoCompleteDuration + ", scheduleType=" + this.scheduleType + ", pickupAt=" + this.pickupAt + ", pickupWindowDuration=" + this.pickupWindowDuration + ", prepTimeDuration=" + this.prepTimeDuration + ", note=" + this.note + ", placedAt=" + this.placedAt + ", acceptedAt=" + this.acceptedAt + ", rejectedAt=" + this.rejectedAt + ", readyAt=" + this.readyAt + ", expiredAt=" + this.expiredAt + ", pickedUpAt=" + this.pickedUpAt + ", canceledAt=" + this.canceledAt + ", cancelReason=" + this.cancelReason + ", isCurbsidePickup=" + this.isCurbsidePickup + ", curbsidePickupDetails=" + this.curbsidePickupDetails + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().recipient(this.getRecipient()).scheduleType(this.getScheduleType()).placedAt(this.getPlacedAt()).acceptedAt(this.getAcceptedAt()).rejectedAt(this.getRejectedAt()).readyAt(this.getReadyAt()).expiredAt(this.getExpiredAt()).pickedUpAt(this.getPickedUpAt()).canceledAt(this.getCanceledAt()).curbsidePickupDetails(this.getCurbsidePickupDetails());
        builder.expiresAt = this.internalGetExpiresAt();
        builder.autoCompleteDuration = this.internalGetAutoCompleteDuration();
        builder.pickupAt = this.internalGetPickupAt();
        builder.pickupWindowDuration = this.internalGetPickupWindowDuration();
        builder.prepTimeDuration = this.internalGetPrepTimeDuration();
        builder.note = this.internalGetNote();
        builder.cancelReason = this.internalGetCancelReason();
        builder.isCurbsidePickup = this.internalGetIsCurbsidePickup();
        return builder;
    }

    public static class Builder {
        private OrderFulfillmentRecipient recipient;
        private OptionalNullable<String> expiresAt;
        private OptionalNullable<String> autoCompleteDuration;
        private String scheduleType;
        private OptionalNullable<String> pickupAt;
        private OptionalNullable<String> pickupWindowDuration;
        private OptionalNullable<String> prepTimeDuration;
        private OptionalNullable<String> note;
        private String placedAt;
        private String acceptedAt;
        private String rejectedAt;
        private String readyAt;
        private String expiredAt;
        private String pickedUpAt;
        private String canceledAt;
        private OptionalNullable<String> cancelReason;
        private OptionalNullable<Boolean> isCurbsidePickup;
        private OrderFulfillmentPickupDetailsCurbsidePickupDetails curbsidePickupDetails;

        public Builder recipient(OrderFulfillmentRecipient recipient) {
            this.recipient = recipient;
            return this;
        }

        public Builder expiresAt(String expiresAt) {
            this.expiresAt = OptionalNullable.of((Object)expiresAt);
            return this;
        }

        public Builder unsetExpiresAt() {
            this.expiresAt = null;
            return this;
        }

        public Builder autoCompleteDuration(String autoCompleteDuration) {
            this.autoCompleteDuration = OptionalNullable.of((Object)autoCompleteDuration);
            return this;
        }

        public Builder unsetAutoCompleteDuration() {
            this.autoCompleteDuration = null;
            return this;
        }

        public Builder scheduleType(String scheduleType) {
            this.scheduleType = scheduleType;
            return this;
        }

        public Builder pickupAt(String pickupAt) {
            this.pickupAt = OptionalNullable.of((Object)pickupAt);
            return this;
        }

        public Builder unsetPickupAt() {
            this.pickupAt = null;
            return this;
        }

        public Builder pickupWindowDuration(String pickupWindowDuration) {
            this.pickupWindowDuration = OptionalNullable.of((Object)pickupWindowDuration);
            return this;
        }

        public Builder unsetPickupWindowDuration() {
            this.pickupWindowDuration = null;
            return this;
        }

        public Builder prepTimeDuration(String prepTimeDuration) {
            this.prepTimeDuration = OptionalNullable.of((Object)prepTimeDuration);
            return this;
        }

        public Builder unsetPrepTimeDuration() {
            this.prepTimeDuration = null;
            return this;
        }

        public Builder note(String note) {
            this.note = OptionalNullable.of((Object)note);
            return this;
        }

        public Builder unsetNote() {
            this.note = null;
            return this;
        }

        public Builder placedAt(String placedAt) {
            this.placedAt = placedAt;
            return this;
        }

        public Builder acceptedAt(String acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        public Builder rejectedAt(String rejectedAt) {
            this.rejectedAt = rejectedAt;
            return this;
        }

        public Builder readyAt(String readyAt) {
            this.readyAt = readyAt;
            return this;
        }

        public Builder expiredAt(String expiredAt) {
            this.expiredAt = expiredAt;
            return this;
        }

        public Builder pickedUpAt(String pickedUpAt) {
            this.pickedUpAt = pickedUpAt;
            return this;
        }

        public Builder canceledAt(String canceledAt) {
            this.canceledAt = canceledAt;
            return this;
        }

        public Builder cancelReason(String cancelReason) {
            this.cancelReason = OptionalNullable.of((Object)cancelReason);
            return this;
        }

        public Builder unsetCancelReason() {
            this.cancelReason = null;
            return this;
        }

        public Builder isCurbsidePickup(Boolean isCurbsidePickup) {
            this.isCurbsidePickup = OptionalNullable.of((Object)isCurbsidePickup);
            return this;
        }

        public Builder unsetIsCurbsidePickup() {
            this.isCurbsidePickup = null;
            return this;
        }

        public Builder curbsidePickupDetails(OrderFulfillmentPickupDetailsCurbsidePickupDetails curbsidePickupDetails) {
            this.curbsidePickupDetails = curbsidePickupDetails;
            return this;
        }

        public OrderFulfillmentPickupDetails build() {
            return new OrderFulfillmentPickupDetails(this.recipient, this.expiresAt, this.autoCompleteDuration, this.scheduleType, this.pickupAt, this.pickupWindowDuration, this.prepTimeDuration, this.note, this.placedAt, this.acceptedAt, this.rejectedAt, this.readyAt, this.expiredAt, this.pickedUpAt, this.canceledAt, this.cancelReason, this.isCurbsidePickup, this.curbsidePickupDetails);
        }
    }
}

