/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.OrderFulfillmentRecipient;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class OrderFulfillmentShipmentDetails {
    private final OrderFulfillmentRecipient recipient;
    private final OptionalNullable<String> carrier;
    private final OptionalNullable<String> shippingNote;
    private final OptionalNullable<String> shippingType;
    private final OptionalNullable<String> trackingNumber;
    private final OptionalNullable<String> trackingUrl;
    private final String placedAt;
    private final String inProgressAt;
    private final String packagedAt;
    private final OptionalNullable<String> expectedShippedAt;
    private final String shippedAt;
    private final OptionalNullable<String> canceledAt;
    private final OptionalNullable<String> cancelReason;
    private final String failedAt;
    private final OptionalNullable<String> failureReason;

    @JsonCreator
    public OrderFulfillmentShipmentDetails(@JsonProperty(value="recipient") OrderFulfillmentRecipient recipient, @JsonProperty(value="carrier") String carrier, @JsonProperty(value="shipping_note") String shippingNote, @JsonProperty(value="shipping_type") String shippingType, @JsonProperty(value="tracking_number") String trackingNumber, @JsonProperty(value="tracking_url") String trackingUrl, @JsonProperty(value="placed_at") String placedAt, @JsonProperty(value="in_progress_at") String inProgressAt, @JsonProperty(value="packaged_at") String packagedAt, @JsonProperty(value="expected_shipped_at") String expectedShippedAt, @JsonProperty(value="shipped_at") String shippedAt, @JsonProperty(value="canceled_at") String canceledAt, @JsonProperty(value="cancel_reason") String cancelReason, @JsonProperty(value="failed_at") String failedAt, @JsonProperty(value="failure_reason") String failureReason) {
        this.recipient = recipient;
        this.carrier = OptionalNullable.of((Object)carrier);
        this.shippingNote = OptionalNullable.of((Object)shippingNote);
        this.shippingType = OptionalNullable.of((Object)shippingType);
        this.trackingNumber = OptionalNullable.of((Object)trackingNumber);
        this.trackingUrl = OptionalNullable.of((Object)trackingUrl);
        this.placedAt = placedAt;
        this.inProgressAt = inProgressAt;
        this.packagedAt = packagedAt;
        this.expectedShippedAt = OptionalNullable.of((Object)expectedShippedAt);
        this.shippedAt = shippedAt;
        this.canceledAt = OptionalNullable.of((Object)canceledAt);
        this.cancelReason = OptionalNullable.of((Object)cancelReason);
        this.failedAt = failedAt;
        this.failureReason = OptionalNullable.of((Object)failureReason);
    }

    protected OrderFulfillmentShipmentDetails(OrderFulfillmentRecipient recipient, OptionalNullable<String> carrier, OptionalNullable<String> shippingNote, OptionalNullable<String> shippingType, OptionalNullable<String> trackingNumber, OptionalNullable<String> trackingUrl, String placedAt, String inProgressAt, String packagedAt, OptionalNullable<String> expectedShippedAt, String shippedAt, OptionalNullable<String> canceledAt, OptionalNullable<String> cancelReason, String failedAt, OptionalNullable<String> failureReason) {
        this.recipient = recipient;
        this.carrier = carrier;
        this.shippingNote = shippingNote;
        this.shippingType = shippingType;
        this.trackingNumber = trackingNumber;
        this.trackingUrl = trackingUrl;
        this.placedAt = placedAt;
        this.inProgressAt = inProgressAt;
        this.packagedAt = packagedAt;
        this.expectedShippedAt = expectedShippedAt;
        this.shippedAt = shippedAt;
        this.canceledAt = canceledAt;
        this.cancelReason = cancelReason;
        this.failedAt = failedAt;
        this.failureReason = failureReason;
    }

    @JsonGetter(value="recipient")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderFulfillmentRecipient getRecipient() {
        return this.recipient;
    }

    @JsonGetter(value="carrier")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCarrier() {
        return this.carrier;
    }

    @JsonIgnore
    public String getCarrier() {
        return (String)OptionalNullable.getFrom(this.carrier);
    }

    @JsonGetter(value="shipping_note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetShippingNote() {
        return this.shippingNote;
    }

    @JsonIgnore
    public String getShippingNote() {
        return (String)OptionalNullable.getFrom(this.shippingNote);
    }

    @JsonGetter(value="shipping_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetShippingType() {
        return this.shippingType;
    }

    @JsonIgnore
    public String getShippingType() {
        return (String)OptionalNullable.getFrom(this.shippingType);
    }

    @JsonGetter(value="tracking_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTrackingNumber() {
        return this.trackingNumber;
    }

    @JsonIgnore
    public String getTrackingNumber() {
        return (String)OptionalNullable.getFrom(this.trackingNumber);
    }

    @JsonGetter(value="tracking_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTrackingUrl() {
        return this.trackingUrl;
    }

    @JsonIgnore
    public String getTrackingUrl() {
        return (String)OptionalNullable.getFrom(this.trackingUrl);
    }

    @JsonGetter(value="placed_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPlacedAt() {
        return this.placedAt;
    }

    @JsonGetter(value="in_progress_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getInProgressAt() {
        return this.inProgressAt;
    }

    @JsonGetter(value="packaged_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPackagedAt() {
        return this.packagedAt;
    }

    @JsonGetter(value="expected_shipped_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetExpectedShippedAt() {
        return this.expectedShippedAt;
    }

    @JsonIgnore
    public String getExpectedShippedAt() {
        return (String)OptionalNullable.getFrom(this.expectedShippedAt);
    }

    @JsonGetter(value="shipped_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getShippedAt() {
        return this.shippedAt;
    }

    @JsonGetter(value="canceled_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCanceledAt() {
        return this.canceledAt;
    }

    @JsonIgnore
    public String getCanceledAt() {
        return (String)OptionalNullable.getFrom(this.canceledAt);
    }

    @JsonGetter(value="cancel_reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCancelReason() {
        return this.cancelReason;
    }

    @JsonIgnore
    public String getCancelReason() {
        return (String)OptionalNullable.getFrom(this.cancelReason);
    }

    @JsonGetter(value="failed_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFailedAt() {
        return this.failedAt;
    }

    @JsonGetter(value="failure_reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetFailureReason() {
        return this.failureReason;
    }

    @JsonIgnore
    public String getFailureReason() {
        return (String)OptionalNullable.getFrom(this.failureReason);
    }

    public int hashCode() {
        return Objects.hash(this.recipient, this.carrier, this.shippingNote, this.shippingType, this.trackingNumber, this.trackingUrl, this.placedAt, this.inProgressAt, this.packagedAt, this.expectedShippedAt, this.shippedAt, this.canceledAt, this.cancelReason, this.failedAt, this.failureReason);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderFulfillmentShipmentDetails)) {
            return false;
        }
        OrderFulfillmentShipmentDetails other = (OrderFulfillmentShipmentDetails)obj;
        return Objects.equals(this.recipient, other.recipient) && Objects.equals(this.carrier, other.carrier) && Objects.equals(this.shippingNote, other.shippingNote) && Objects.equals(this.shippingType, other.shippingType) && Objects.equals(this.trackingNumber, other.trackingNumber) && Objects.equals(this.trackingUrl, other.trackingUrl) && Objects.equals(this.placedAt, other.placedAt) && Objects.equals(this.inProgressAt, other.inProgressAt) && Objects.equals(this.packagedAt, other.packagedAt) && Objects.equals(this.expectedShippedAt, other.expectedShippedAt) && Objects.equals(this.shippedAt, other.shippedAt) && Objects.equals(this.canceledAt, other.canceledAt) && Objects.equals(this.cancelReason, other.cancelReason) && Objects.equals(this.failedAt, other.failedAt) && Objects.equals(this.failureReason, other.failureReason);
    }

    public String toString() {
        return "OrderFulfillmentShipmentDetails [recipient=" + this.recipient + ", carrier=" + this.carrier + ", shippingNote=" + this.shippingNote + ", shippingType=" + this.shippingType + ", trackingNumber=" + this.trackingNumber + ", trackingUrl=" + this.trackingUrl + ", placedAt=" + this.placedAt + ", inProgressAt=" + this.inProgressAt + ", packagedAt=" + this.packagedAt + ", expectedShippedAt=" + this.expectedShippedAt + ", shippedAt=" + this.shippedAt + ", canceledAt=" + this.canceledAt + ", cancelReason=" + this.cancelReason + ", failedAt=" + this.failedAt + ", failureReason=" + this.failureReason + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().recipient(this.getRecipient()).placedAt(this.getPlacedAt()).inProgressAt(this.getInProgressAt()).packagedAt(this.getPackagedAt()).shippedAt(this.getShippedAt()).failedAt(this.getFailedAt());
        builder.carrier = this.internalGetCarrier();
        builder.shippingNote = this.internalGetShippingNote();
        builder.shippingType = this.internalGetShippingType();
        builder.trackingNumber = this.internalGetTrackingNumber();
        builder.trackingUrl = this.internalGetTrackingUrl();
        builder.expectedShippedAt = this.internalGetExpectedShippedAt();
        builder.canceledAt = this.internalGetCanceledAt();
        builder.cancelReason = this.internalGetCancelReason();
        builder.failureReason = this.internalGetFailureReason();
        return builder;
    }

    public static class Builder {
        private OrderFulfillmentRecipient recipient;
        private OptionalNullable<String> carrier;
        private OptionalNullable<String> shippingNote;
        private OptionalNullable<String> shippingType;
        private OptionalNullable<String> trackingNumber;
        private OptionalNullable<String> trackingUrl;
        private String placedAt;
        private String inProgressAt;
        private String packagedAt;
        private OptionalNullable<String> expectedShippedAt;
        private String shippedAt;
        private OptionalNullable<String> canceledAt;
        private OptionalNullable<String> cancelReason;
        private String failedAt;
        private OptionalNullable<String> failureReason;

        public Builder recipient(OrderFulfillmentRecipient recipient) {
            this.recipient = recipient;
            return this;
        }

        public Builder carrier(String carrier) {
            this.carrier = OptionalNullable.of((Object)carrier);
            return this;
        }

        public Builder unsetCarrier() {
            this.carrier = null;
            return this;
        }

        public Builder shippingNote(String shippingNote) {
            this.shippingNote = OptionalNullable.of((Object)shippingNote);
            return this;
        }

        public Builder unsetShippingNote() {
            this.shippingNote = null;
            return this;
        }

        public Builder shippingType(String shippingType) {
            this.shippingType = OptionalNullable.of((Object)shippingType);
            return this;
        }

        public Builder unsetShippingType() {
            this.shippingType = null;
            return this;
        }

        public Builder trackingNumber(String trackingNumber) {
            this.trackingNumber = OptionalNullable.of((Object)trackingNumber);
            return this;
        }

        public Builder unsetTrackingNumber() {
            this.trackingNumber = null;
            return this;
        }

        public Builder trackingUrl(String trackingUrl) {
            this.trackingUrl = OptionalNullable.of((Object)trackingUrl);
            return this;
        }

        public Builder unsetTrackingUrl() {
            this.trackingUrl = null;
            return this;
        }

        public Builder placedAt(String placedAt) {
            this.placedAt = placedAt;
            return this;
        }

        public Builder inProgressAt(String inProgressAt) {
            this.inProgressAt = inProgressAt;
            return this;
        }

        public Builder packagedAt(String packagedAt) {
            this.packagedAt = packagedAt;
            return this;
        }

        public Builder expectedShippedAt(String expectedShippedAt) {
            this.expectedShippedAt = OptionalNullable.of((Object)expectedShippedAt);
            return this;
        }

        public Builder unsetExpectedShippedAt() {
            this.expectedShippedAt = null;
            return this;
        }

        public Builder shippedAt(String shippedAt) {
            this.shippedAt = shippedAt;
            return this;
        }

        public Builder canceledAt(String canceledAt) {
            this.canceledAt = OptionalNullable.of((Object)canceledAt);
            return this;
        }

        public Builder unsetCanceledAt() {
            this.canceledAt = null;
            return this;
        }

        public Builder cancelReason(String cancelReason) {
            this.cancelReason = OptionalNullable.of((Object)cancelReason);
            return this;
        }

        public Builder unsetCancelReason() {
            this.cancelReason = null;
            return this;
        }

        public Builder failedAt(String failedAt) {
            this.failedAt = failedAt;
            return this;
        }

        public Builder failureReason(String failureReason) {
            this.failureReason = OptionalNullable.of((Object)failureReason);
            return this;
        }

        public Builder unsetFailureReason() {
            this.failureReason = null;
            return this;
        }

        public OrderFulfillmentShipmentDetails build() {
            return new OrderFulfillmentShipmentDetails(this.recipient, this.carrier, this.shippingNote, this.shippingType, this.trackingNumber, this.trackingUrl, this.placedAt, this.inProgressAt, this.packagedAt, this.expectedShippedAt, this.shippedAt, this.canceledAt, this.cancelReason, this.failedAt, this.failureReason);
        }
    }
}

