/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class OrderLineItemAppliedTax {
    private final OptionalNullable<String> uid;
    private final String taxUid;
    private final Money appliedMoney;

    @JsonCreator
    public OrderLineItemAppliedTax(@JsonProperty(value="tax_uid") String taxUid, @JsonProperty(value="uid") String uid, @JsonProperty(value="applied_money") Money appliedMoney) {
        this.uid = OptionalNullable.of((Object)uid);
        this.taxUid = taxUid;
        this.appliedMoney = appliedMoney;
    }

    protected OrderLineItemAppliedTax(String taxUid, OptionalNullable<String> uid, Money appliedMoney) {
        this.uid = uid;
        this.taxUid = taxUid;
        this.appliedMoney = appliedMoney;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetUid() {
        return this.uid;
    }

    @JsonIgnore
    public String getUid() {
        return (String)OptionalNullable.getFrom(this.uid);
    }

    @JsonGetter(value="tax_uid")
    public String getTaxUid() {
        return this.taxUid;
    }

    @JsonGetter(value="applied_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAppliedMoney() {
        return this.appliedMoney;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.taxUid, this.appliedMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderLineItemAppliedTax)) {
            return false;
        }
        OrderLineItemAppliedTax other = (OrderLineItemAppliedTax)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.taxUid, other.taxUid) && Objects.equals(this.appliedMoney, other.appliedMoney);
    }

    public String toString() {
        return "OrderLineItemAppliedTax [taxUid=" + this.taxUid + ", uid=" + this.uid + ", appliedMoney=" + this.appliedMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.taxUid).appliedMoney(this.getAppliedMoney());
        builder.uid = this.internalGetUid();
        return builder;
    }

    public static class Builder {
        private String taxUid;
        private OptionalNullable<String> uid;
        private Money appliedMoney;

        public Builder(String taxUid) {
            this.taxUid = taxUid;
        }

        public Builder taxUid(String taxUid) {
            this.taxUid = taxUid;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = OptionalNullable.of((Object)uid);
            return this;
        }

        public Builder unsetUid() {
            this.uid = null;
            return this;
        }

        public Builder appliedMoney(Money appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public OrderLineItemAppliedTax build() {
            return new OrderLineItemAppliedTax(this.taxUid, this.uid, this.appliedMoney);
        }
    }
}

