/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.OrderLineItemPricingBlocklistsBlockedDiscount;
import com.squareup.square.models.OrderLineItemPricingBlocklistsBlockedTax;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class OrderLineItemPricingBlocklists {
    private final OptionalNullable<List<OrderLineItemPricingBlocklistsBlockedDiscount>> blockedDiscounts;
    private final OptionalNullable<List<OrderLineItemPricingBlocklistsBlockedTax>> blockedTaxes;

    @JsonCreator
    public OrderLineItemPricingBlocklists(@JsonProperty(value="blocked_discounts") List<OrderLineItemPricingBlocklistsBlockedDiscount> blockedDiscounts, @JsonProperty(value="blocked_taxes") List<OrderLineItemPricingBlocklistsBlockedTax> blockedTaxes) {
        this.blockedDiscounts = OptionalNullable.of(blockedDiscounts);
        this.blockedTaxes = OptionalNullable.of(blockedTaxes);
    }

    protected OrderLineItemPricingBlocklists(OptionalNullable<List<OrderLineItemPricingBlocklistsBlockedDiscount>> blockedDiscounts, OptionalNullable<List<OrderLineItemPricingBlocklistsBlockedTax>> blockedTaxes) {
        this.blockedDiscounts = blockedDiscounts;
        this.blockedTaxes = blockedTaxes;
    }

    @JsonGetter(value="blocked_discounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderLineItemPricingBlocklistsBlockedDiscount>> internalGetBlockedDiscounts() {
        return this.blockedDiscounts;
    }

    @JsonIgnore
    public List<OrderLineItemPricingBlocklistsBlockedDiscount> getBlockedDiscounts() {
        return (List)OptionalNullable.getFrom(this.blockedDiscounts);
    }

    @JsonGetter(value="blocked_taxes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderLineItemPricingBlocklistsBlockedTax>> internalGetBlockedTaxes() {
        return this.blockedTaxes;
    }

    @JsonIgnore
    public List<OrderLineItemPricingBlocklistsBlockedTax> getBlockedTaxes() {
        return (List)OptionalNullable.getFrom(this.blockedTaxes);
    }

    public int hashCode() {
        return Objects.hash(this.blockedDiscounts, this.blockedTaxes);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderLineItemPricingBlocklists)) {
            return false;
        }
        OrderLineItemPricingBlocklists other = (OrderLineItemPricingBlocklists)obj;
        return Objects.equals(this.blockedDiscounts, other.blockedDiscounts) && Objects.equals(this.blockedTaxes, other.blockedTaxes);
    }

    public String toString() {
        return "OrderLineItemPricingBlocklists [blockedDiscounts=" + this.blockedDiscounts + ", blockedTaxes=" + this.blockedTaxes + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.blockedDiscounts = this.internalGetBlockedDiscounts();
        builder.blockedTaxes = this.internalGetBlockedTaxes();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<List<OrderLineItemPricingBlocklistsBlockedDiscount>> blockedDiscounts;
        private OptionalNullable<List<OrderLineItemPricingBlocklistsBlockedTax>> blockedTaxes;

        public Builder blockedDiscounts(List<OrderLineItemPricingBlocklistsBlockedDiscount> blockedDiscounts) {
            this.blockedDiscounts = OptionalNullable.of(blockedDiscounts);
            return this;
        }

        public Builder unsetBlockedDiscounts() {
            this.blockedDiscounts = null;
            return this;
        }

        public Builder blockedTaxes(List<OrderLineItemPricingBlocklistsBlockedTax> blockedTaxes) {
            this.blockedTaxes = OptionalNullable.of(blockedTaxes);
            return this;
        }

        public Builder unsetBlockedTaxes() {
            this.blockedTaxes = null;
            return this;
        }

        public OrderLineItemPricingBlocklists build() {
            return new OrderLineItemPricingBlocklists(this.blockedDiscounts, this.blockedTaxes);
        }
    }
}

