/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.MeasurementUnit;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class OrderQuantityUnit {
    private final MeasurementUnit measurementUnit;
    private final OptionalNullable<Integer> precision;
    private final OptionalNullable<String> catalogObjectId;
    private final OptionalNullable<Long> catalogVersion;

    @JsonCreator
    public OrderQuantityUnit(@JsonProperty(value="measurement_unit") MeasurementUnit measurementUnit, @JsonProperty(value="precision") Integer precision, @JsonProperty(value="catalog_object_id") String catalogObjectId, @JsonProperty(value="catalog_version") Long catalogVersion) {
        this.measurementUnit = measurementUnit;
        this.precision = OptionalNullable.of((Object)precision);
        this.catalogObjectId = OptionalNullable.of((Object)catalogObjectId);
        this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
    }

    protected OrderQuantityUnit(MeasurementUnit measurementUnit, OptionalNullable<Integer> precision, OptionalNullable<String> catalogObjectId, OptionalNullable<Long> catalogVersion) {
        this.measurementUnit = measurementUnit;
        this.precision = precision;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
    }

    @JsonGetter(value="measurement_unit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public MeasurementUnit getMeasurementUnit() {
        return this.measurementUnit;
    }

    @JsonGetter(value="precision")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetPrecision() {
        return this.precision;
    }

    @JsonIgnore
    public Integer getPrecision() {
        return (Integer)OptionalNullable.getFrom(this.precision);
    }

    @JsonGetter(value="catalog_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonIgnore
    public String getCatalogObjectId() {
        return (String)OptionalNullable.getFrom(this.catalogObjectId);
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonIgnore
    public Long getCatalogVersion() {
        return (Long)OptionalNullable.getFrom(this.catalogVersion);
    }

    public int hashCode() {
        return Objects.hash(this.measurementUnit, this.precision, this.catalogObjectId, this.catalogVersion);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderQuantityUnit)) {
            return false;
        }
        OrderQuantityUnit other = (OrderQuantityUnit)obj;
        return Objects.equals(this.measurementUnit, other.measurementUnit) && Objects.equals(this.precision, other.precision) && Objects.equals(this.catalogObjectId, other.catalogObjectId) && Objects.equals(this.catalogVersion, other.catalogVersion);
    }

    public String toString() {
        return "OrderQuantityUnit [measurementUnit=" + this.measurementUnit + ", precision=" + this.precision + ", catalogObjectId=" + this.catalogObjectId + ", catalogVersion=" + this.catalogVersion + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().measurementUnit(this.getMeasurementUnit());
        builder.precision = this.internalGetPrecision();
        builder.catalogObjectId = this.internalGetCatalogObjectId();
        builder.catalogVersion = this.internalGetCatalogVersion();
        return builder;
    }

    public static class Builder {
        private MeasurementUnit measurementUnit;
        private OptionalNullable<Integer> precision;
        private OptionalNullable<String> catalogObjectId;
        private OptionalNullable<Long> catalogVersion;

        public Builder measurementUnit(MeasurementUnit measurementUnit) {
            this.measurementUnit = measurementUnit;
            return this;
        }

        public Builder precision(Integer precision) {
            this.precision = OptionalNullable.of((Object)precision);
            return this;
        }

        public Builder unsetPrecision() {
            this.precision = null;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = OptionalNullable.of((Object)catalogObjectId);
            return this;
        }

        public Builder unsetCatalogObjectId() {
            this.catalogObjectId = null;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
            return this;
        }

        public Builder unsetCatalogVersion() {
            this.catalogVersion = null;
            return this;
        }

        public OrderQuantityUnit build() {
            return new OrderQuantityUnit(this.measurementUnit, this.precision, this.catalogObjectId, this.catalogVersion);
        }
    }
}

