/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import com.squareup.square.models.OrderLineItemAppliedDiscount;
import com.squareup.square.models.OrderLineItemAppliedServiceCharge;
import com.squareup.square.models.OrderLineItemAppliedTax;
import com.squareup.square.models.OrderQuantityUnit;
import com.squareup.square.models.OrderReturnLineItemModifier;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class OrderReturnLineItem {
    private final OptionalNullable<String> uid;
    private final OptionalNullable<String> sourceLineItemUid;
    private final OptionalNullable<String> name;
    private final String quantity;
    private final OrderQuantityUnit quantityUnit;
    private final OptionalNullable<String> note;
    private final OptionalNullable<String> catalogObjectId;
    private final OptionalNullable<Long> catalogVersion;
    private final OptionalNullable<String> variationName;
    private final String itemType;
    private final OptionalNullable<List<OrderReturnLineItemModifier>> returnModifiers;
    private final OptionalNullable<List<OrderLineItemAppliedTax>> appliedTaxes;
    private final OptionalNullable<List<OrderLineItemAppliedDiscount>> appliedDiscounts;
    private final Money basePriceMoney;
    private final Money variationTotalPriceMoney;
    private final Money grossReturnMoney;
    private final Money totalTaxMoney;
    private final Money totalDiscountMoney;
    private final Money totalMoney;
    private final OptionalNullable<List<OrderLineItemAppliedServiceCharge>> appliedServiceCharges;
    private final Money totalServiceChargeMoney;

    @JsonCreator
    public OrderReturnLineItem(@JsonProperty(value="quantity") String quantity, @JsonProperty(value="uid") String uid, @JsonProperty(value="source_line_item_uid") String sourceLineItemUid, @JsonProperty(value="name") String name, @JsonProperty(value="quantity_unit") OrderQuantityUnit quantityUnit, @JsonProperty(value="note") String note, @JsonProperty(value="catalog_object_id") String catalogObjectId, @JsonProperty(value="catalog_version") Long catalogVersion, @JsonProperty(value="variation_name") String variationName, @JsonProperty(value="item_type") String itemType, @JsonProperty(value="return_modifiers") List<OrderReturnLineItemModifier> returnModifiers, @JsonProperty(value="applied_taxes") List<OrderLineItemAppliedTax> appliedTaxes, @JsonProperty(value="applied_discounts") List<OrderLineItemAppliedDiscount> appliedDiscounts, @JsonProperty(value="base_price_money") Money basePriceMoney, @JsonProperty(value="variation_total_price_money") Money variationTotalPriceMoney, @JsonProperty(value="gross_return_money") Money grossReturnMoney, @JsonProperty(value="total_tax_money") Money totalTaxMoney, @JsonProperty(value="total_discount_money") Money totalDiscountMoney, @JsonProperty(value="total_money") Money totalMoney, @JsonProperty(value="applied_service_charges") List<OrderLineItemAppliedServiceCharge> appliedServiceCharges, @JsonProperty(value="total_service_charge_money") Money totalServiceChargeMoney) {
        this.uid = OptionalNullable.of((Object)uid);
        this.sourceLineItemUid = OptionalNullable.of((Object)sourceLineItemUid);
        this.name = OptionalNullable.of((Object)name);
        this.quantity = quantity;
        this.quantityUnit = quantityUnit;
        this.note = OptionalNullable.of((Object)note);
        this.catalogObjectId = OptionalNullable.of((Object)catalogObjectId);
        this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
        this.variationName = OptionalNullable.of((Object)variationName);
        this.itemType = itemType;
        this.returnModifiers = OptionalNullable.of(returnModifiers);
        this.appliedTaxes = OptionalNullable.of(appliedTaxes);
        this.appliedDiscounts = OptionalNullable.of(appliedDiscounts);
        this.basePriceMoney = basePriceMoney;
        this.variationTotalPriceMoney = variationTotalPriceMoney;
        this.grossReturnMoney = grossReturnMoney;
        this.totalTaxMoney = totalTaxMoney;
        this.totalDiscountMoney = totalDiscountMoney;
        this.totalMoney = totalMoney;
        this.appliedServiceCharges = OptionalNullable.of(appliedServiceCharges);
        this.totalServiceChargeMoney = totalServiceChargeMoney;
    }

    protected OrderReturnLineItem(String quantity, OptionalNullable<String> uid, OptionalNullable<String> sourceLineItemUid, OptionalNullable<String> name, OrderQuantityUnit quantityUnit, OptionalNullable<String> note, OptionalNullable<String> catalogObjectId, OptionalNullable<Long> catalogVersion, OptionalNullable<String> variationName, String itemType, OptionalNullable<List<OrderReturnLineItemModifier>> returnModifiers, OptionalNullable<List<OrderLineItemAppliedTax>> appliedTaxes, OptionalNullable<List<OrderLineItemAppliedDiscount>> appliedDiscounts, Money basePriceMoney, Money variationTotalPriceMoney, Money grossReturnMoney, Money totalTaxMoney, Money totalDiscountMoney, Money totalMoney, OptionalNullable<List<OrderLineItemAppliedServiceCharge>> appliedServiceCharges, Money totalServiceChargeMoney) {
        this.uid = uid;
        this.sourceLineItemUid = sourceLineItemUid;
        this.name = name;
        this.quantity = quantity;
        this.quantityUnit = quantityUnit;
        this.note = note;
        this.catalogObjectId = catalogObjectId;
        this.catalogVersion = catalogVersion;
        this.variationName = variationName;
        this.itemType = itemType;
        this.returnModifiers = returnModifiers;
        this.appliedTaxes = appliedTaxes;
        this.appliedDiscounts = appliedDiscounts;
        this.basePriceMoney = basePriceMoney;
        this.variationTotalPriceMoney = variationTotalPriceMoney;
        this.grossReturnMoney = grossReturnMoney;
        this.totalTaxMoney = totalTaxMoney;
        this.totalDiscountMoney = totalDiscountMoney;
        this.totalMoney = totalMoney;
        this.appliedServiceCharges = appliedServiceCharges;
        this.totalServiceChargeMoney = totalServiceChargeMoney;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetUid() {
        return this.uid;
    }

    @JsonIgnore
    public String getUid() {
        return (String)OptionalNullable.getFrom(this.uid);
    }

    @JsonGetter(value="source_line_item_uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetSourceLineItemUid() {
        return this.sourceLineItemUid;
    }

    @JsonIgnore
    public String getSourceLineItemUid() {
        return (String)OptionalNullable.getFrom(this.sourceLineItemUid);
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetName() {
        return this.name;
    }

    @JsonIgnore
    public String getName() {
        return (String)OptionalNullable.getFrom(this.name);
    }

    @JsonGetter(value="quantity")
    public String getQuantity() {
        return this.quantity;
    }

    @JsonGetter(value="quantity_unit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderQuantityUnit getQuantityUnit() {
        return this.quantityUnit;
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetNote() {
        return this.note;
    }

    @JsonIgnore
    public String getNote() {
        return (String)OptionalNullable.getFrom(this.note);
    }

    @JsonGetter(value="catalog_object_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCatalogObjectId() {
        return this.catalogObjectId;
    }

    @JsonIgnore
    public String getCatalogObjectId() {
        return (String)OptionalNullable.getFrom(this.catalogObjectId);
    }

    @JsonGetter(value="catalog_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetCatalogVersion() {
        return this.catalogVersion;
    }

    @JsonIgnore
    public Long getCatalogVersion() {
        return (Long)OptionalNullable.getFrom(this.catalogVersion);
    }

    @JsonGetter(value="variation_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetVariationName() {
        return this.variationName;
    }

    @JsonIgnore
    public String getVariationName() {
        return (String)OptionalNullable.getFrom(this.variationName);
    }

    @JsonGetter(value="item_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getItemType() {
        return this.itemType;
    }

    @JsonGetter(value="return_modifiers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderReturnLineItemModifier>> internalGetReturnModifiers() {
        return this.returnModifiers;
    }

    @JsonIgnore
    public List<OrderReturnLineItemModifier> getReturnModifiers() {
        return (List)OptionalNullable.getFrom(this.returnModifiers);
    }

    @JsonGetter(value="applied_taxes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderLineItemAppliedTax>> internalGetAppliedTaxes() {
        return this.appliedTaxes;
    }

    @JsonIgnore
    public List<OrderLineItemAppliedTax> getAppliedTaxes() {
        return (List)OptionalNullable.getFrom(this.appliedTaxes);
    }

    @JsonGetter(value="applied_discounts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderLineItemAppliedDiscount>> internalGetAppliedDiscounts() {
        return this.appliedDiscounts;
    }

    @JsonIgnore
    public List<OrderLineItemAppliedDiscount> getAppliedDiscounts() {
        return (List)OptionalNullable.getFrom(this.appliedDiscounts);
    }

    @JsonGetter(value="base_price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getBasePriceMoney() {
        return this.basePriceMoney;
    }

    @JsonGetter(value="variation_total_price_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getVariationTotalPriceMoney() {
        return this.variationTotalPriceMoney;
    }

    @JsonGetter(value="gross_return_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getGrossReturnMoney() {
        return this.grossReturnMoney;
    }

    @JsonGetter(value="total_tax_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalTaxMoney() {
        return this.totalTaxMoney;
    }

    @JsonGetter(value="total_discount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalDiscountMoney() {
        return this.totalDiscountMoney;
    }

    @JsonGetter(value="total_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalMoney() {
        return this.totalMoney;
    }

    @JsonGetter(value="applied_service_charges")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderLineItemAppliedServiceCharge>> internalGetAppliedServiceCharges() {
        return this.appliedServiceCharges;
    }

    @JsonIgnore
    public List<OrderLineItemAppliedServiceCharge> getAppliedServiceCharges() {
        return (List)OptionalNullable.getFrom(this.appliedServiceCharges);
    }

    @JsonGetter(value="total_service_charge_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTotalServiceChargeMoney() {
        return this.totalServiceChargeMoney;
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.sourceLineItemUid, this.name, this.quantity, this.quantityUnit, this.note, this.catalogObjectId, this.catalogVersion, this.variationName, this.itemType, this.returnModifiers, this.appliedTaxes, this.appliedDiscounts, this.basePriceMoney, this.variationTotalPriceMoney, this.grossReturnMoney, this.totalTaxMoney, this.totalDiscountMoney, this.totalMoney, this.appliedServiceCharges, this.totalServiceChargeMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderReturnLineItem)) {
            return false;
        }
        OrderReturnLineItem other = (OrderReturnLineItem)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.sourceLineItemUid, other.sourceLineItemUid) && Objects.equals(this.name, other.name) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.quantityUnit, other.quantityUnit) && Objects.equals(this.note, other.note) && Objects.equals(this.catalogObjectId, other.catalogObjectId) && Objects.equals(this.catalogVersion, other.catalogVersion) && Objects.equals(this.variationName, other.variationName) && Objects.equals(this.itemType, other.itemType) && Objects.equals(this.returnModifiers, other.returnModifiers) && Objects.equals(this.appliedTaxes, other.appliedTaxes) && Objects.equals(this.appliedDiscounts, other.appliedDiscounts) && Objects.equals(this.basePriceMoney, other.basePriceMoney) && Objects.equals(this.variationTotalPriceMoney, other.variationTotalPriceMoney) && Objects.equals(this.grossReturnMoney, other.grossReturnMoney) && Objects.equals(this.totalTaxMoney, other.totalTaxMoney) && Objects.equals(this.totalDiscountMoney, other.totalDiscountMoney) && Objects.equals(this.totalMoney, other.totalMoney) && Objects.equals(this.appliedServiceCharges, other.appliedServiceCharges) && Objects.equals(this.totalServiceChargeMoney, other.totalServiceChargeMoney);
    }

    public String toString() {
        return "OrderReturnLineItem [quantity=" + this.quantity + ", uid=" + this.uid + ", sourceLineItemUid=" + this.sourceLineItemUid + ", name=" + this.name + ", quantityUnit=" + this.quantityUnit + ", note=" + this.note + ", catalogObjectId=" + this.catalogObjectId + ", catalogVersion=" + this.catalogVersion + ", variationName=" + this.variationName + ", itemType=" + this.itemType + ", returnModifiers=" + this.returnModifiers + ", appliedTaxes=" + this.appliedTaxes + ", appliedDiscounts=" + this.appliedDiscounts + ", basePriceMoney=" + this.basePriceMoney + ", variationTotalPriceMoney=" + this.variationTotalPriceMoney + ", grossReturnMoney=" + this.grossReturnMoney + ", totalTaxMoney=" + this.totalTaxMoney + ", totalDiscountMoney=" + this.totalDiscountMoney + ", totalMoney=" + this.totalMoney + ", appliedServiceCharges=" + this.appliedServiceCharges + ", totalServiceChargeMoney=" + this.totalServiceChargeMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.quantity).quantityUnit(this.getQuantityUnit()).itemType(this.getItemType()).basePriceMoney(this.getBasePriceMoney()).variationTotalPriceMoney(this.getVariationTotalPriceMoney()).grossReturnMoney(this.getGrossReturnMoney()).totalTaxMoney(this.getTotalTaxMoney()).totalDiscountMoney(this.getTotalDiscountMoney()).totalMoney(this.getTotalMoney()).totalServiceChargeMoney(this.getTotalServiceChargeMoney());
        builder.uid = this.internalGetUid();
        builder.sourceLineItemUid = this.internalGetSourceLineItemUid();
        builder.name = this.internalGetName();
        builder.note = this.internalGetNote();
        builder.catalogObjectId = this.internalGetCatalogObjectId();
        builder.catalogVersion = this.internalGetCatalogVersion();
        builder.variationName = this.internalGetVariationName();
        builder.returnModifiers = this.internalGetReturnModifiers();
        builder.appliedTaxes = this.internalGetAppliedTaxes();
        builder.appliedDiscounts = this.internalGetAppliedDiscounts();
        builder.appliedServiceCharges = this.internalGetAppliedServiceCharges();
        return builder;
    }

    public static class Builder {
        private String quantity;
        private OptionalNullable<String> uid;
        private OptionalNullable<String> sourceLineItemUid;
        private OptionalNullable<String> name;
        private OrderQuantityUnit quantityUnit;
        private OptionalNullable<String> note;
        private OptionalNullable<String> catalogObjectId;
        private OptionalNullable<Long> catalogVersion;
        private OptionalNullable<String> variationName;
        private String itemType;
        private OptionalNullable<List<OrderReturnLineItemModifier>> returnModifiers;
        private OptionalNullable<List<OrderLineItemAppliedTax>> appliedTaxes;
        private OptionalNullable<List<OrderLineItemAppliedDiscount>> appliedDiscounts;
        private Money basePriceMoney;
        private Money variationTotalPriceMoney;
        private Money grossReturnMoney;
        private Money totalTaxMoney;
        private Money totalDiscountMoney;
        private Money totalMoney;
        private OptionalNullable<List<OrderLineItemAppliedServiceCharge>> appliedServiceCharges;
        private Money totalServiceChargeMoney;

        public Builder(String quantity) {
            this.quantity = quantity;
        }

        public Builder quantity(String quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder uid(String uid) {
            this.uid = OptionalNullable.of((Object)uid);
            return this;
        }

        public Builder unsetUid() {
            this.uid = null;
            return this;
        }

        public Builder sourceLineItemUid(String sourceLineItemUid) {
            this.sourceLineItemUid = OptionalNullable.of((Object)sourceLineItemUid);
            return this;
        }

        public Builder unsetSourceLineItemUid() {
            this.sourceLineItemUid = null;
            return this;
        }

        public Builder name(String name) {
            this.name = OptionalNullable.of((Object)name);
            return this;
        }

        public Builder unsetName() {
            this.name = null;
            return this;
        }

        public Builder quantityUnit(OrderQuantityUnit quantityUnit) {
            this.quantityUnit = quantityUnit;
            return this;
        }

        public Builder note(String note) {
            this.note = OptionalNullable.of((Object)note);
            return this;
        }

        public Builder unsetNote() {
            this.note = null;
            return this;
        }

        public Builder catalogObjectId(String catalogObjectId) {
            this.catalogObjectId = OptionalNullable.of((Object)catalogObjectId);
            return this;
        }

        public Builder unsetCatalogObjectId() {
            this.catalogObjectId = null;
            return this;
        }

        public Builder catalogVersion(Long catalogVersion) {
            this.catalogVersion = OptionalNullable.of((Object)catalogVersion);
            return this;
        }

        public Builder unsetCatalogVersion() {
            this.catalogVersion = null;
            return this;
        }

        public Builder variationName(String variationName) {
            this.variationName = OptionalNullable.of((Object)variationName);
            return this;
        }

        public Builder unsetVariationName() {
            this.variationName = null;
            return this;
        }

        public Builder itemType(String itemType) {
            this.itemType = itemType;
            return this;
        }

        public Builder returnModifiers(List<OrderReturnLineItemModifier> returnModifiers) {
            this.returnModifiers = OptionalNullable.of(returnModifiers);
            return this;
        }

        public Builder unsetReturnModifiers() {
            this.returnModifiers = null;
            return this;
        }

        public Builder appliedTaxes(List<OrderLineItemAppliedTax> appliedTaxes) {
            this.appliedTaxes = OptionalNullable.of(appliedTaxes);
            return this;
        }

        public Builder unsetAppliedTaxes() {
            this.appliedTaxes = null;
            return this;
        }

        public Builder appliedDiscounts(List<OrderLineItemAppliedDiscount> appliedDiscounts) {
            this.appliedDiscounts = OptionalNullable.of(appliedDiscounts);
            return this;
        }

        public Builder unsetAppliedDiscounts() {
            this.appliedDiscounts = null;
            return this;
        }

        public Builder basePriceMoney(Money basePriceMoney) {
            this.basePriceMoney = basePriceMoney;
            return this;
        }

        public Builder variationTotalPriceMoney(Money variationTotalPriceMoney) {
            this.variationTotalPriceMoney = variationTotalPriceMoney;
            return this;
        }

        public Builder grossReturnMoney(Money grossReturnMoney) {
            this.grossReturnMoney = grossReturnMoney;
            return this;
        }

        public Builder totalTaxMoney(Money totalTaxMoney) {
            this.totalTaxMoney = totalTaxMoney;
            return this;
        }

        public Builder totalDiscountMoney(Money totalDiscountMoney) {
            this.totalDiscountMoney = totalDiscountMoney;
            return this;
        }

        public Builder totalMoney(Money totalMoney) {
            this.totalMoney = totalMoney;
            return this;
        }

        public Builder appliedServiceCharges(List<OrderLineItemAppliedServiceCharge> appliedServiceCharges) {
            this.appliedServiceCharges = OptionalNullable.of(appliedServiceCharges);
            return this;
        }

        public Builder unsetAppliedServiceCharges() {
            this.appliedServiceCharges = null;
            return this;
        }

        public Builder totalServiceChargeMoney(Money totalServiceChargeMoney) {
            this.totalServiceChargeMoney = totalServiceChargeMoney;
            return this;
        }

        public OrderReturnLineItem build() {
            return new OrderReturnLineItem(this.quantity, this.uid, this.sourceLineItemUid, this.name, this.quantityUnit, this.note, this.catalogObjectId, this.catalogVersion, this.variationName, this.itemType, this.returnModifiers, this.appliedTaxes, this.appliedDiscounts, this.basePriceMoney, this.variationTotalPriceMoney, this.grossReturnMoney, this.totalTaxMoney, this.totalDiscountMoney, this.totalMoney, this.appliedServiceCharges, this.totalServiceChargeMoney);
        }
    }
}

