/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class OrderReturnTip {
    private final OptionalNullable<String> uid;
    private final Money appliedMoney;
    private final OptionalNullable<String> sourceTenderUid;
    private final OptionalNullable<String> sourceTenderId;

    @JsonCreator
    public OrderReturnTip(@JsonProperty(value="uid") String uid, @JsonProperty(value="applied_money") Money appliedMoney, @JsonProperty(value="source_tender_uid") String sourceTenderUid, @JsonProperty(value="source_tender_id") String sourceTenderId) {
        this.uid = OptionalNullable.of((Object)uid);
        this.appliedMoney = appliedMoney;
        this.sourceTenderUid = OptionalNullable.of((Object)sourceTenderUid);
        this.sourceTenderId = OptionalNullable.of((Object)sourceTenderId);
    }

    protected OrderReturnTip(OptionalNullable<String> uid, Money appliedMoney, OptionalNullable<String> sourceTenderUid, OptionalNullable<String> sourceTenderId) {
        this.uid = uid;
        this.appliedMoney = appliedMoney;
        this.sourceTenderUid = sourceTenderUid;
        this.sourceTenderId = sourceTenderId;
    }

    @JsonGetter(value="uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetUid() {
        return this.uid;
    }

    @JsonIgnore
    public String getUid() {
        return (String)OptionalNullable.getFrom(this.uid);
    }

    @JsonGetter(value="applied_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAppliedMoney() {
        return this.appliedMoney;
    }

    @JsonGetter(value="source_tender_uid")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetSourceTenderUid() {
        return this.sourceTenderUid;
    }

    @JsonIgnore
    public String getSourceTenderUid() {
        return (String)OptionalNullable.getFrom(this.sourceTenderUid);
    }

    @JsonGetter(value="source_tender_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetSourceTenderId() {
        return this.sourceTenderId;
    }

    @JsonIgnore
    public String getSourceTenderId() {
        return (String)OptionalNullable.getFrom(this.sourceTenderId);
    }

    public int hashCode() {
        return Objects.hash(this.uid, this.appliedMoney, this.sourceTenderUid, this.sourceTenderId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OrderReturnTip)) {
            return false;
        }
        OrderReturnTip other = (OrderReturnTip)obj;
        return Objects.equals(this.uid, other.uid) && Objects.equals(this.appliedMoney, other.appliedMoney) && Objects.equals(this.sourceTenderUid, other.sourceTenderUid) && Objects.equals(this.sourceTenderId, other.sourceTenderId);
    }

    public String toString() {
        return "OrderReturnTip [uid=" + this.uid + ", appliedMoney=" + this.appliedMoney + ", sourceTenderUid=" + this.sourceTenderUid + ", sourceTenderId=" + this.sourceTenderId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().appliedMoney(this.getAppliedMoney());
        builder.uid = this.internalGetUid();
        builder.sourceTenderUid = this.internalGetSourceTenderUid();
        builder.sourceTenderId = this.internalGetSourceTenderId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> uid;
        private Money appliedMoney;
        private OptionalNullable<String> sourceTenderUid;
        private OptionalNullable<String> sourceTenderId;

        public Builder uid(String uid) {
            this.uid = OptionalNullable.of((Object)uid);
            return this;
        }

        public Builder unsetUid() {
            this.uid = null;
            return this;
        }

        public Builder appliedMoney(Money appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public Builder sourceTenderUid(String sourceTenderUid) {
            this.sourceTenderUid = OptionalNullable.of((Object)sourceTenderUid);
            return this;
        }

        public Builder unsetSourceTenderUid() {
            this.sourceTenderUid = null;
            return this;
        }

        public Builder sourceTenderId(String sourceTenderId) {
            this.sourceTenderId = OptionalNullable.of((Object)sourceTenderId);
            return this;
        }

        public Builder unsetSourceTenderId() {
            this.sourceTenderId = null;
            return this;
        }

        public OrderReturnTip build() {
            return new OrderReturnTip(this.uid, this.appliedMoney, this.sourceTenderUid, this.sourceTenderId);
        }
    }
}

