/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class PaginationCursor {
    private final OptionalNullable<String> orderValue;

    @JsonCreator
    public PaginationCursor(@JsonProperty(value="order_value") String orderValue) {
        this.orderValue = OptionalNullable.of((Object)orderValue);
    }

    protected PaginationCursor(OptionalNullable<String> orderValue) {
        this.orderValue = orderValue;
    }

    @JsonGetter(value="order_value")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetOrderValue() {
        return this.orderValue;
    }

    @JsonIgnore
    public String getOrderValue() {
        return (String)OptionalNullable.getFrom(this.orderValue);
    }

    public int hashCode() {
        return Objects.hash(this.orderValue);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PaginationCursor)) {
            return false;
        }
        PaginationCursor other = (PaginationCursor)obj;
        return Objects.equals(this.orderValue, other.orderValue);
    }

    public String toString() {
        return "PaginationCursor [orderValue=" + this.orderValue + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.orderValue = this.internalGetOrderValue();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> orderValue;

        public Builder orderValue(String orderValue) {
            this.orderValue = OptionalNullable.of((Object)orderValue);
            return this;
        }

        public Builder unsetOrderValue() {
            this.orderValue = null;
            return this;
        }

        public PaginationCursor build() {
            return new PaginationCursor(this.orderValue);
        }
    }
}

