/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class PauseSubscriptionRequest {
    private final OptionalNullable<String> pauseEffectiveDate;
    private final OptionalNullable<Long> pauseCycleDuration;
    private final OptionalNullable<String> resumeEffectiveDate;
    private final String resumeChangeTiming;
    private final OptionalNullable<String> pauseReason;

    @JsonCreator
    public PauseSubscriptionRequest(@JsonProperty(value="pause_effective_date") String pauseEffectiveDate, @JsonProperty(value="pause_cycle_duration") Long pauseCycleDuration, @JsonProperty(value="resume_effective_date") String resumeEffectiveDate, @JsonProperty(value="resume_change_timing") String resumeChangeTiming, @JsonProperty(value="pause_reason") String pauseReason) {
        this.pauseEffectiveDate = OptionalNullable.of((Object)pauseEffectiveDate);
        this.pauseCycleDuration = OptionalNullable.of((Object)pauseCycleDuration);
        this.resumeEffectiveDate = OptionalNullable.of((Object)resumeEffectiveDate);
        this.resumeChangeTiming = resumeChangeTiming;
        this.pauseReason = OptionalNullable.of((Object)pauseReason);
    }

    protected PauseSubscriptionRequest(OptionalNullable<String> pauseEffectiveDate, OptionalNullable<Long> pauseCycleDuration, OptionalNullable<String> resumeEffectiveDate, String resumeChangeTiming, OptionalNullable<String> pauseReason) {
        this.pauseEffectiveDate = pauseEffectiveDate;
        this.pauseCycleDuration = pauseCycleDuration;
        this.resumeEffectiveDate = resumeEffectiveDate;
        this.resumeChangeTiming = resumeChangeTiming;
        this.pauseReason = pauseReason;
    }

    @JsonGetter(value="pause_effective_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPauseEffectiveDate() {
        return this.pauseEffectiveDate;
    }

    @JsonIgnore
    public String getPauseEffectiveDate() {
        return (String)OptionalNullable.getFrom(this.pauseEffectiveDate);
    }

    @JsonGetter(value="pause_cycle_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetPauseCycleDuration() {
        return this.pauseCycleDuration;
    }

    @JsonIgnore
    public Long getPauseCycleDuration() {
        return (Long)OptionalNullable.getFrom(this.pauseCycleDuration);
    }

    @JsonGetter(value="resume_effective_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetResumeEffectiveDate() {
        return this.resumeEffectiveDate;
    }

    @JsonIgnore
    public String getResumeEffectiveDate() {
        return (String)OptionalNullable.getFrom(this.resumeEffectiveDate);
    }

    @JsonGetter(value="resume_change_timing")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getResumeChangeTiming() {
        return this.resumeChangeTiming;
    }

    @JsonGetter(value="pause_reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPauseReason() {
        return this.pauseReason;
    }

    @JsonIgnore
    public String getPauseReason() {
        return (String)OptionalNullable.getFrom(this.pauseReason);
    }

    public int hashCode() {
        return Objects.hash(this.pauseEffectiveDate, this.pauseCycleDuration, this.resumeEffectiveDate, this.resumeChangeTiming, this.pauseReason);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PauseSubscriptionRequest)) {
            return false;
        }
        PauseSubscriptionRequest other = (PauseSubscriptionRequest)obj;
        return Objects.equals(this.pauseEffectiveDate, other.pauseEffectiveDate) && Objects.equals(this.pauseCycleDuration, other.pauseCycleDuration) && Objects.equals(this.resumeEffectiveDate, other.resumeEffectiveDate) && Objects.equals(this.resumeChangeTiming, other.resumeChangeTiming) && Objects.equals(this.pauseReason, other.pauseReason);
    }

    public String toString() {
        return "PauseSubscriptionRequest [pauseEffectiveDate=" + this.pauseEffectiveDate + ", pauseCycleDuration=" + this.pauseCycleDuration + ", resumeEffectiveDate=" + this.resumeEffectiveDate + ", resumeChangeTiming=" + this.resumeChangeTiming + ", pauseReason=" + this.pauseReason + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().resumeChangeTiming(this.getResumeChangeTiming());
        builder.pauseEffectiveDate = this.internalGetPauseEffectiveDate();
        builder.pauseCycleDuration = this.internalGetPauseCycleDuration();
        builder.resumeEffectiveDate = this.internalGetResumeEffectiveDate();
        builder.pauseReason = this.internalGetPauseReason();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> pauseEffectiveDate;
        private OptionalNullable<Long> pauseCycleDuration;
        private OptionalNullable<String> resumeEffectiveDate;
        private String resumeChangeTiming;
        private OptionalNullable<String> pauseReason;

        public Builder pauseEffectiveDate(String pauseEffectiveDate) {
            this.pauseEffectiveDate = OptionalNullable.of((Object)pauseEffectiveDate);
            return this;
        }

        public Builder unsetPauseEffectiveDate() {
            this.pauseEffectiveDate = null;
            return this;
        }

        public Builder pauseCycleDuration(Long pauseCycleDuration) {
            this.pauseCycleDuration = OptionalNullable.of((Object)pauseCycleDuration);
            return this;
        }

        public Builder unsetPauseCycleDuration() {
            this.pauseCycleDuration = null;
            return this;
        }

        public Builder resumeEffectiveDate(String resumeEffectiveDate) {
            this.resumeEffectiveDate = OptionalNullable.of((Object)resumeEffectiveDate);
            return this;
        }

        public Builder unsetResumeEffectiveDate() {
            this.resumeEffectiveDate = null;
            return this;
        }

        public Builder resumeChangeTiming(String resumeChangeTiming) {
            this.resumeChangeTiming = resumeChangeTiming;
            return this;
        }

        public Builder pauseReason(String pauseReason) {
            this.pauseReason = OptionalNullable.of((Object)pauseReason);
            return this;
        }

        public Builder unsetPauseReason() {
            this.pauseReason = null;
            return this;
        }

        public PauseSubscriptionRequest build() {
            return new PauseSubscriptionRequest(this.pauseEffectiveDate, this.pauseCycleDuration, this.resumeEffectiveDate, this.resumeChangeTiming, this.pauseReason);
        }
    }
}

