/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class PayOrderRequest {
    private final String idempotencyKey;
    private final OptionalNullable<Integer> orderVersion;
    private final OptionalNullable<List<String>> paymentIds;

    @JsonCreator
    public PayOrderRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="order_version") Integer orderVersion, @JsonProperty(value="payment_ids") List<String> paymentIds) {
        this.idempotencyKey = idempotencyKey;
        this.orderVersion = OptionalNullable.of((Object)orderVersion);
        this.paymentIds = OptionalNullable.of(paymentIds);
    }

    protected PayOrderRequest(String idempotencyKey, OptionalNullable<Integer> orderVersion, OptionalNullable<List<String>> paymentIds) {
        this.idempotencyKey = idempotencyKey;
        this.orderVersion = orderVersion;
        this.paymentIds = paymentIds;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="order_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetOrderVersion() {
        return this.orderVersion;
    }

    @JsonIgnore
    public Integer getOrderVersion() {
        return (Integer)OptionalNullable.getFrom(this.orderVersion);
    }

    @JsonGetter(value="payment_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetPaymentIds() {
        return this.paymentIds;
    }

    @JsonIgnore
    public List<String> getPaymentIds() {
        return (List)OptionalNullable.getFrom(this.paymentIds);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.orderVersion, this.paymentIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PayOrderRequest)) {
            return false;
        }
        PayOrderRequest other = (PayOrderRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.orderVersion, other.orderVersion) && Objects.equals(this.paymentIds, other.paymentIds);
    }

    public String toString() {
        return "PayOrderRequest [idempotencyKey=" + this.idempotencyKey + ", orderVersion=" + this.orderVersion + ", paymentIds=" + this.paymentIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey);
        builder.orderVersion = this.internalGetOrderVersion();
        builder.paymentIds = this.internalGetPaymentIds();
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private OptionalNullable<Integer> orderVersion;
        private OptionalNullable<List<String>> paymentIds;

        public Builder(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder orderVersion(Integer orderVersion) {
            this.orderVersion = OptionalNullable.of((Object)orderVersion);
            return this;
        }

        public Builder unsetOrderVersion() {
            this.orderVersion = null;
            return this;
        }

        public Builder paymentIds(List<String> paymentIds) {
            this.paymentIds = OptionalNullable.of(paymentIds);
            return this;
        }

        public Builder unsetPaymentIds() {
            this.paymentIds = null;
            return this;
        }

        public PayOrderRequest build() {
            return new PayOrderRequest(this.idempotencyKey, this.orderVersion, this.paymentIds);
        }
    }
}

