/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class PaymentBalanceActivityAutomaticSavingsDetail {
    private final OptionalNullable<String> paymentId;
    private final OptionalNullable<String> payoutId;

    @JsonCreator
    public PaymentBalanceActivityAutomaticSavingsDetail(@JsonProperty(value="payment_id") String paymentId, @JsonProperty(value="payout_id") String payoutId) {
        this.paymentId = OptionalNullable.of((Object)paymentId);
        this.payoutId = OptionalNullable.of((Object)payoutId);
    }

    protected PaymentBalanceActivityAutomaticSavingsDetail(OptionalNullable<String> paymentId, OptionalNullable<String> payoutId) {
        this.paymentId = paymentId;
        this.payoutId = payoutId;
    }

    @JsonGetter(value="payment_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPaymentId() {
        return this.paymentId;
    }

    @JsonIgnore
    public String getPaymentId() {
        return (String)OptionalNullable.getFrom(this.paymentId);
    }

    @JsonGetter(value="payout_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPayoutId() {
        return this.payoutId;
    }

    @JsonIgnore
    public String getPayoutId() {
        return (String)OptionalNullable.getFrom(this.payoutId);
    }

    public int hashCode() {
        return Objects.hash(this.paymentId, this.payoutId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PaymentBalanceActivityAutomaticSavingsDetail)) {
            return false;
        }
        PaymentBalanceActivityAutomaticSavingsDetail other = (PaymentBalanceActivityAutomaticSavingsDetail)obj;
        return Objects.equals(this.paymentId, other.paymentId) && Objects.equals(this.payoutId, other.payoutId);
    }

    public String toString() {
        return "PaymentBalanceActivityAutomaticSavingsDetail [paymentId=" + this.paymentId + ", payoutId=" + this.payoutId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.paymentId = this.internalGetPaymentId();
        builder.payoutId = this.internalGetPayoutId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> paymentId;
        private OptionalNullable<String> payoutId;

        public Builder paymentId(String paymentId) {
            this.paymentId = OptionalNullable.of((Object)paymentId);
            return this;
        }

        public Builder unsetPaymentId() {
            this.paymentId = null;
            return this;
        }

        public Builder payoutId(String payoutId) {
            this.payoutId = OptionalNullable.of((Object)payoutId);
            return this;
        }

        public Builder unsetPayoutId() {
            this.payoutId = null;
            return this;
        }

        public PaymentBalanceActivityAutomaticSavingsDetail build() {
            return new PaymentBalanceActivityAutomaticSavingsDetail(this.paymentId, this.payoutId);
        }
    }
}

