/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CheckoutOptions;
import com.squareup.square.models.PrePopulatedData;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class PaymentLink {
    private final String id;
    private final int version;
    private final OptionalNullable<String> description;
    private final String orderId;
    private final CheckoutOptions checkoutOptions;
    private final PrePopulatedData prePopulatedData;
    private final String url;
    private final String longUrl;
    private final String createdAt;
    private final String updatedAt;
    private final OptionalNullable<String> paymentNote;

    @JsonCreator
    public PaymentLink(@JsonProperty(value="version") int version, @JsonProperty(value="id") String id, @JsonProperty(value="description") String description, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="checkout_options") CheckoutOptions checkoutOptions, @JsonProperty(value="pre_populated_data") PrePopulatedData prePopulatedData, @JsonProperty(value="url") String url, @JsonProperty(value="long_url") String longUrl, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="payment_note") String paymentNote) {
        this.id = id;
        this.version = version;
        this.description = OptionalNullable.of((Object)description);
        this.orderId = orderId;
        this.checkoutOptions = checkoutOptions;
        this.prePopulatedData = prePopulatedData;
        this.url = url;
        this.longUrl = longUrl;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.paymentNote = OptionalNullable.of((Object)paymentNote);
    }

    protected PaymentLink(int version, String id, OptionalNullable<String> description, String orderId, CheckoutOptions checkoutOptions, PrePopulatedData prePopulatedData, String url, String longUrl, String createdAt, String updatedAt, OptionalNullable<String> paymentNote) {
        this.id = id;
        this.version = version;
        this.description = description;
        this.orderId = orderId;
        this.checkoutOptions = checkoutOptions;
        this.prePopulatedData = prePopulatedData;
        this.url = url;
        this.longUrl = longUrl;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.paymentNote = paymentNote;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="version")
    public int getVersion() {
        return this.version;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDescription() {
        return this.description;
    }

    @JsonIgnore
    public String getDescription() {
        return (String)OptionalNullable.getFrom(this.description);
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrderId() {
        return this.orderId;
    }

    @JsonGetter(value="checkout_options")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CheckoutOptions getCheckoutOptions() {
        return this.checkoutOptions;
    }

    @JsonGetter(value="pre_populated_data")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PrePopulatedData getPrePopulatedData() {
        return this.prePopulatedData;
    }

    @JsonGetter(value="url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUrl() {
        return this.url;
    }

    @JsonGetter(value="long_url")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getLongUrl() {
        return this.longUrl;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="payment_note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPaymentNote() {
        return this.paymentNote;
    }

    @JsonIgnore
    public String getPaymentNote() {
        return (String)OptionalNullable.getFrom(this.paymentNote);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.description, this.orderId, this.checkoutOptions, this.prePopulatedData, this.url, this.longUrl, this.createdAt, this.updatedAt, this.paymentNote);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PaymentLink)) {
            return false;
        }
        PaymentLink other = (PaymentLink)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.version, other.version) && Objects.equals(this.description, other.description) && Objects.equals(this.orderId, other.orderId) && Objects.equals(this.checkoutOptions, other.checkoutOptions) && Objects.equals(this.prePopulatedData, other.prePopulatedData) && Objects.equals(this.url, other.url) && Objects.equals(this.longUrl, other.longUrl) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.paymentNote, other.paymentNote);
    }

    public String toString() {
        return "PaymentLink [version=" + this.version + ", id=" + this.id + ", description=" + this.description + ", orderId=" + this.orderId + ", checkoutOptions=" + this.checkoutOptions + ", prePopulatedData=" + this.prePopulatedData + ", url=" + this.url + ", longUrl=" + this.longUrl + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", paymentNote=" + this.paymentNote + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.version).id(this.getId()).orderId(this.getOrderId()).checkoutOptions(this.getCheckoutOptions()).prePopulatedData(this.getPrePopulatedData()).url(this.getUrl()).longUrl(this.getLongUrl()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt());
        builder.description = this.internalGetDescription();
        builder.paymentNote = this.internalGetPaymentNote();
        return builder;
    }

    public static class Builder {
        private int version;
        private String id;
        private OptionalNullable<String> description;
        private String orderId;
        private CheckoutOptions checkoutOptions;
        private PrePopulatedData prePopulatedData;
        private String url;
        private String longUrl;
        private String createdAt;
        private String updatedAt;
        private OptionalNullable<String> paymentNote;

        public Builder(int version) {
            this.version = version;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder description(String description) {
            this.description = OptionalNullable.of((Object)description);
            return this;
        }

        public Builder unsetDescription() {
            this.description = null;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder checkoutOptions(CheckoutOptions checkoutOptions) {
            this.checkoutOptions = checkoutOptions;
            return this;
        }

        public Builder prePopulatedData(PrePopulatedData prePopulatedData) {
            this.prePopulatedData = prePopulatedData;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder longUrl(String longUrl) {
            this.longUrl = longUrl;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder paymentNote(String paymentNote) {
            this.paymentNote = OptionalNullable.of((Object)paymentNote);
            return this;
        }

        public Builder unsetPaymentNote() {
            this.paymentNote = null;
            return this;
        }

        public PaymentLink build() {
            return new PaymentLink(this.version, this.id, this.description, this.orderId, this.checkoutOptions, this.prePopulatedData, this.url, this.longUrl, this.createdAt, this.updatedAt, this.paymentNote);
        }
    }
}

