/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CatalogObject;
import com.squareup.square.models.Order;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class PaymentLinkRelatedResources {
    private final OptionalNullable<List<Order>> orders;
    private final OptionalNullable<List<CatalogObject>> subscriptionPlans;

    @JsonCreator
    public PaymentLinkRelatedResources(@JsonProperty(value="orders") List<Order> orders, @JsonProperty(value="subscription_plans") List<CatalogObject> subscriptionPlans) {
        this.orders = OptionalNullable.of(orders);
        this.subscriptionPlans = OptionalNullable.of(subscriptionPlans);
    }

    protected PaymentLinkRelatedResources(OptionalNullable<List<Order>> orders, OptionalNullable<List<CatalogObject>> subscriptionPlans) {
        this.orders = orders;
        this.subscriptionPlans = subscriptionPlans;
    }

    @JsonGetter(value="orders")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<Order>> internalGetOrders() {
        return this.orders;
    }

    @JsonIgnore
    public List<Order> getOrders() {
        return (List)OptionalNullable.getFrom(this.orders);
    }

    @JsonGetter(value="subscription_plans")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<CatalogObject>> internalGetSubscriptionPlans() {
        return this.subscriptionPlans;
    }

    @JsonIgnore
    public List<CatalogObject> getSubscriptionPlans() {
        return (List)OptionalNullable.getFrom(this.subscriptionPlans);
    }

    public int hashCode() {
        return Objects.hash(this.orders, this.subscriptionPlans);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PaymentLinkRelatedResources)) {
            return false;
        }
        PaymentLinkRelatedResources other = (PaymentLinkRelatedResources)obj;
        return Objects.equals(this.orders, other.orders) && Objects.equals(this.subscriptionPlans, other.subscriptionPlans);
    }

    public String toString() {
        return "PaymentLinkRelatedResources [orders=" + this.orders + ", subscriptionPlans=" + this.subscriptionPlans + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.orders = this.internalGetOrders();
        builder.subscriptionPlans = this.internalGetSubscriptionPlans();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<List<Order>> orders;
        private OptionalNullable<List<CatalogObject>> subscriptionPlans;

        public Builder orders(List<Order> orders) {
            this.orders = OptionalNullable.of(orders);
            return this;
        }

        public Builder unsetOrders() {
            this.orders = null;
            return this;
        }

        public Builder subscriptionPlans(List<CatalogObject> subscriptionPlans) {
            this.subscriptionPlans = OptionalNullable.of(subscriptionPlans);
            return this;
        }

        public Builder unsetSubscriptionPlans() {
            this.subscriptionPlans = null;
            return this;
        }

        public PaymentLinkRelatedResources build() {
            return new PaymentLinkRelatedResources(this.orders, this.subscriptionPlans);
        }
    }
}

