/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class PaymentOptions {
    private final OptionalNullable<Boolean> autocomplete;
    private final OptionalNullable<String> delayDuration;
    private final OptionalNullable<Boolean> acceptPartialAuthorization;
    private final String delayAction;

    @JsonCreator
    public PaymentOptions(@JsonProperty(value="autocomplete") Boolean autocomplete, @JsonProperty(value="delay_duration") String delayDuration, @JsonProperty(value="accept_partial_authorization") Boolean acceptPartialAuthorization, @JsonProperty(value="delay_action") String delayAction) {
        this.autocomplete = OptionalNullable.of((Object)autocomplete);
        this.delayDuration = OptionalNullable.of((Object)delayDuration);
        this.acceptPartialAuthorization = OptionalNullable.of((Object)acceptPartialAuthorization);
        this.delayAction = delayAction;
    }

    protected PaymentOptions(OptionalNullable<Boolean> autocomplete, OptionalNullable<String> delayDuration, OptionalNullable<Boolean> acceptPartialAuthorization, String delayAction) {
        this.autocomplete = autocomplete;
        this.delayDuration = delayDuration;
        this.acceptPartialAuthorization = acceptPartialAuthorization;
        this.delayAction = delayAction;
    }

    @JsonGetter(value="autocomplete")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetAutocomplete() {
        return this.autocomplete;
    }

    @JsonIgnore
    public Boolean getAutocomplete() {
        return (Boolean)OptionalNullable.getFrom(this.autocomplete);
    }

    @JsonGetter(value="delay_duration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDelayDuration() {
        return this.delayDuration;
    }

    @JsonIgnore
    public String getDelayDuration() {
        return (String)OptionalNullable.getFrom(this.delayDuration);
    }

    @JsonGetter(value="accept_partial_authorization")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Boolean> internalGetAcceptPartialAuthorization() {
        return this.acceptPartialAuthorization;
    }

    @JsonIgnore
    public Boolean getAcceptPartialAuthorization() {
        return (Boolean)OptionalNullable.getFrom(this.acceptPartialAuthorization);
    }

    @JsonGetter(value="delay_action")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDelayAction() {
        return this.delayAction;
    }

    public int hashCode() {
        return Objects.hash(this.autocomplete, this.delayDuration, this.acceptPartialAuthorization, this.delayAction);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PaymentOptions)) {
            return false;
        }
        PaymentOptions other = (PaymentOptions)obj;
        return Objects.equals(this.autocomplete, other.autocomplete) && Objects.equals(this.delayDuration, other.delayDuration) && Objects.equals(this.acceptPartialAuthorization, other.acceptPartialAuthorization) && Objects.equals(this.delayAction, other.delayAction);
    }

    public String toString() {
        return "PaymentOptions [autocomplete=" + this.autocomplete + ", delayDuration=" + this.delayDuration + ", acceptPartialAuthorization=" + this.acceptPartialAuthorization + ", delayAction=" + this.delayAction + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().delayAction(this.getDelayAction());
        builder.autocomplete = this.internalGetAutocomplete();
        builder.delayDuration = this.internalGetDelayDuration();
        builder.acceptPartialAuthorization = this.internalGetAcceptPartialAuthorization();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<Boolean> autocomplete;
        private OptionalNullable<String> delayDuration;
        private OptionalNullable<Boolean> acceptPartialAuthorization;
        private String delayAction;

        public Builder autocomplete(Boolean autocomplete) {
            this.autocomplete = OptionalNullable.of((Object)autocomplete);
            return this;
        }

        public Builder unsetAutocomplete() {
            this.autocomplete = null;
            return this;
        }

        public Builder delayDuration(String delayDuration) {
            this.delayDuration = OptionalNullable.of((Object)delayDuration);
            return this;
        }

        public Builder unsetDelayDuration() {
            this.delayDuration = null;
            return this;
        }

        public Builder acceptPartialAuthorization(Boolean acceptPartialAuthorization) {
            this.acceptPartialAuthorization = OptionalNullable.of((Object)acceptPartialAuthorization);
            return this;
        }

        public Builder unsetAcceptPartialAuthorization() {
            this.acceptPartialAuthorization = null;
            return this;
        }

        public Builder delayAction(String delayAction) {
            this.delayAction = delayAction;
            return this;
        }

        public PaymentOptions build() {
            return new PaymentOptions(this.autocomplete, this.delayDuration, this.acceptPartialAuthorization, this.delayAction);
        }
    }
}

