/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.DestinationDetails;
import com.squareup.square.models.Money;
import com.squareup.square.models.ProcessingFee;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class PaymentRefund {
    private final String id;
    private final OptionalNullable<String> status;
    private final OptionalNullable<String> locationId;
    private final Boolean unlinked;
    private final OptionalNullable<String> destinationType;
    private final DestinationDetails destinationDetails;
    private final Money amountMoney;
    private final Money appFeeMoney;
    private final OptionalNullable<List<ProcessingFee>> processingFee;
    private final OptionalNullable<String> paymentId;
    private final OptionalNullable<String> orderId;
    private final OptionalNullable<String> reason;
    private final String createdAt;
    private final String updatedAt;
    private final String teamMemberId;

    @JsonCreator
    public PaymentRefund(@JsonProperty(value="id") String id, @JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="status") String status, @JsonProperty(value="location_id") String locationId, @JsonProperty(value="unlinked") Boolean unlinked, @JsonProperty(value="destination_type") String destinationType, @JsonProperty(value="destination_details") DestinationDetails destinationDetails, @JsonProperty(value="app_fee_money") Money appFeeMoney, @JsonProperty(value="processing_fee") List<ProcessingFee> processingFee, @JsonProperty(value="payment_id") String paymentId, @JsonProperty(value="order_id") String orderId, @JsonProperty(value="reason") String reason, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="team_member_id") String teamMemberId) {
        this.id = id;
        this.status = OptionalNullable.of((Object)status);
        this.locationId = OptionalNullable.of((Object)locationId);
        this.unlinked = unlinked;
        this.destinationType = OptionalNullable.of((Object)destinationType);
        this.destinationDetails = destinationDetails;
        this.amountMoney = amountMoney;
        this.appFeeMoney = appFeeMoney;
        this.processingFee = OptionalNullable.of(processingFee);
        this.paymentId = OptionalNullable.of((Object)paymentId);
        this.orderId = OptionalNullable.of((Object)orderId);
        this.reason = OptionalNullable.of((Object)reason);
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.teamMemberId = teamMemberId;
    }

    protected PaymentRefund(String id, Money amountMoney, OptionalNullable<String> status, OptionalNullable<String> locationId, Boolean unlinked, OptionalNullable<String> destinationType, DestinationDetails destinationDetails, Money appFeeMoney, OptionalNullable<List<ProcessingFee>> processingFee, OptionalNullable<String> paymentId, OptionalNullable<String> orderId, OptionalNullable<String> reason, String createdAt, String updatedAt, String teamMemberId) {
        this.id = id;
        this.status = status;
        this.locationId = locationId;
        this.unlinked = unlinked;
        this.destinationType = destinationType;
        this.destinationDetails = destinationDetails;
        this.amountMoney = amountMoney;
        this.appFeeMoney = appFeeMoney;
        this.processingFee = processingFee;
        this.paymentId = paymentId;
        this.orderId = orderId;
        this.reason = reason;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.teamMemberId = teamMemberId;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetStatus() {
        return this.status;
    }

    @JsonIgnore
    public String getStatus() {
        return (String)OptionalNullable.getFrom(this.status);
    }

    @JsonGetter(value="location_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLocationId() {
        return this.locationId;
    }

    @JsonIgnore
    public String getLocationId() {
        return (String)OptionalNullable.getFrom(this.locationId);
    }

    @JsonGetter(value="unlinked")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getUnlinked() {
        return this.unlinked;
    }

    @JsonGetter(value="destination_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetDestinationType() {
        return this.destinationType;
    }

    @JsonIgnore
    public String getDestinationType() {
        return (String)OptionalNullable.getFrom(this.destinationType);
    }

    @JsonGetter(value="destination_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DestinationDetails getDestinationDetails() {
        return this.destinationDetails;
    }

    @JsonGetter(value="amount_money")
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="app_fee_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAppFeeMoney() {
        return this.appFeeMoney;
    }

    @JsonGetter(value="processing_fee")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<ProcessingFee>> internalGetProcessingFee() {
        return this.processingFee;
    }

    @JsonIgnore
    public List<ProcessingFee> getProcessingFee() {
        return (List)OptionalNullable.getFrom(this.processingFee);
    }

    @JsonGetter(value="payment_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetPaymentId() {
        return this.paymentId;
    }

    @JsonIgnore
    public String getPaymentId() {
        return (String)OptionalNullable.getFrom(this.paymentId);
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetOrderId() {
        return this.orderId;
    }

    @JsonIgnore
    public String getOrderId() {
        return (String)OptionalNullable.getFrom(this.orderId);
    }

    @JsonGetter(value="reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetReason() {
        return this.reason;
    }

    @JsonIgnore
    public String getReason() {
        return (String)OptionalNullable.getFrom(this.reason);
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.locationId, this.unlinked, this.destinationType, this.destinationDetails, this.amountMoney, this.appFeeMoney, this.processingFee, this.paymentId, this.orderId, this.reason, this.createdAt, this.updatedAt, this.teamMemberId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PaymentRefund)) {
            return false;
        }
        PaymentRefund other = (PaymentRefund)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.status, other.status) && Objects.equals(this.locationId, other.locationId) && Objects.equals(this.unlinked, other.unlinked) && Objects.equals(this.destinationType, other.destinationType) && Objects.equals(this.destinationDetails, other.destinationDetails) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.appFeeMoney, other.appFeeMoney) && Objects.equals(this.processingFee, other.processingFee) && Objects.equals(this.paymentId, other.paymentId) && Objects.equals(this.orderId, other.orderId) && Objects.equals(this.reason, other.reason) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.teamMemberId, other.teamMemberId);
    }

    public String toString() {
        return "PaymentRefund [id=" + this.id + ", amountMoney=" + this.amountMoney + ", status=" + this.status + ", locationId=" + this.locationId + ", unlinked=" + this.unlinked + ", destinationType=" + this.destinationType + ", destinationDetails=" + this.destinationDetails + ", appFeeMoney=" + this.appFeeMoney + ", processingFee=" + this.processingFee + ", paymentId=" + this.paymentId + ", orderId=" + this.orderId + ", reason=" + this.reason + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", teamMemberId=" + this.teamMemberId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.id, this.amountMoney).unlinked(this.getUnlinked()).destinationDetails(this.getDestinationDetails()).appFeeMoney(this.getAppFeeMoney()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).teamMemberId(this.getTeamMemberId());
        builder.status = this.internalGetStatus();
        builder.locationId = this.internalGetLocationId();
        builder.destinationType = this.internalGetDestinationType();
        builder.processingFee = this.internalGetProcessingFee();
        builder.paymentId = this.internalGetPaymentId();
        builder.orderId = this.internalGetOrderId();
        builder.reason = this.internalGetReason();
        return builder;
    }

    public static class Builder {
        private String id;
        private Money amountMoney;
        private OptionalNullable<String> status;
        private OptionalNullable<String> locationId;
        private Boolean unlinked;
        private OptionalNullable<String> destinationType;
        private DestinationDetails destinationDetails;
        private Money appFeeMoney;
        private OptionalNullable<List<ProcessingFee>> processingFee;
        private OptionalNullable<String> paymentId;
        private OptionalNullable<String> orderId;
        private OptionalNullable<String> reason;
        private String createdAt;
        private String updatedAt;
        private String teamMemberId;

        public Builder(String id, Money amountMoney) {
            this.id = id;
            this.amountMoney = amountMoney;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder status(String status) {
            this.status = OptionalNullable.of((Object)status);
            return this;
        }

        public Builder unsetStatus() {
            this.status = null;
            return this;
        }

        public Builder locationId(String locationId) {
            this.locationId = OptionalNullable.of((Object)locationId);
            return this;
        }

        public Builder unsetLocationId() {
            this.locationId = null;
            return this;
        }

        public Builder unlinked(Boolean unlinked) {
            this.unlinked = unlinked;
            return this;
        }

        public Builder destinationType(String destinationType) {
            this.destinationType = OptionalNullable.of((Object)destinationType);
            return this;
        }

        public Builder unsetDestinationType() {
            this.destinationType = null;
            return this;
        }

        public Builder destinationDetails(DestinationDetails destinationDetails) {
            this.destinationDetails = destinationDetails;
            return this;
        }

        public Builder appFeeMoney(Money appFeeMoney) {
            this.appFeeMoney = appFeeMoney;
            return this;
        }

        public Builder processingFee(List<ProcessingFee> processingFee) {
            this.processingFee = OptionalNullable.of(processingFee);
            return this;
        }

        public Builder unsetProcessingFee() {
            this.processingFee = null;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = OptionalNullable.of((Object)paymentId);
            return this;
        }

        public Builder unsetPaymentId() {
            this.paymentId = null;
            return this;
        }

        public Builder orderId(String orderId) {
            this.orderId = OptionalNullable.of((Object)orderId);
            return this;
        }

        public Builder unsetOrderId() {
            this.orderId = null;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = OptionalNullable.of((Object)reason);
            return this;
        }

        public Builder unsetReason() {
            this.reason = null;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public PaymentRefund build() {
            return new PaymentRefund(this.id, this.amountMoney, this.status, this.locationId, this.unlinked, this.destinationType, this.destinationDetails, this.appFeeMoney, this.processingFee, this.paymentId, this.orderId, this.reason, this.createdAt, this.updatedAt, this.teamMemberId);
        }
    }
}

