/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class PayoutFee {
    private final Money amountMoney;
    private final OptionalNullable<String> effectiveAt;
    private final String type;

    @JsonCreator
    public PayoutFee(@JsonProperty(value="amount_money") Money amountMoney, @JsonProperty(value="effective_at") String effectiveAt, @JsonProperty(value="type") String type) {
        this.amountMoney = amountMoney;
        this.effectiveAt = OptionalNullable.of((Object)effectiveAt);
        this.type = type;
    }

    protected PayoutFee(Money amountMoney, OptionalNullable<String> effectiveAt, String type) {
        this.amountMoney = amountMoney;
        this.effectiveAt = effectiveAt;
        this.type = type;
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="effective_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEffectiveAt() {
        return this.effectiveAt;
    }

    @JsonIgnore
    public String getEffectiveAt() {
        return (String)OptionalNullable.getFrom(this.effectiveAt);
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.amountMoney, this.effectiveAt, this.type);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PayoutFee)) {
            return false;
        }
        PayoutFee other = (PayoutFee)obj;
        return Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.effectiveAt, other.effectiveAt) && Objects.equals(this.type, other.type);
    }

    public String toString() {
        return "PayoutFee [amountMoney=" + this.amountMoney + ", effectiveAt=" + this.effectiveAt + ", type=" + this.type + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().amountMoney(this.getAmountMoney()).type(this.getType());
        builder.effectiveAt = this.internalGetEffectiveAt();
        return builder;
    }

    public static class Builder {
        private Money amountMoney;
        private OptionalNullable<String> effectiveAt;
        private String type;

        public Builder amountMoney(Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder effectiveAt(String effectiveAt) {
            this.effectiveAt = OptionalNullable.of((Object)effectiveAt);
            return this;
        }

        public Builder unsetEffectiveAt() {
            this.effectiveAt = null;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public PayoutFee build() {
            return new PayoutFee(this.amountMoney, this.effectiveAt, this.type);
        }
    }
}

